/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class PropertyUserOperationLogTest {
    private static final String USER_ID = "testUserId";
    private static final String PROPERTY_NAME = "TEST_PROPERTY";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void tearDown() {
        this.managementService.deleteProperty(PROPERTY_NAME);
    }

    @Test
    public void testCreateProperty() {
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)PROPERTY_NAME);
    }

    @Test
    public void testUpdateProperty() {
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.setProperty(PROPERTY_NAME, "testValue2");
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Update");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)PROPERTY_NAME);
    }

    @Test
    public void testDeleteProperty() {
        this.managementService.setProperty(PROPERTY_NAME, "testValue");
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteProperty(PROPERTY_NAME);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)PROPERTY_NAME);
    }

    @Test
    public void testDeletePropertyNonExisting() {
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.deleteProperty(PROPERTY_NAME);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(0L);
    }
}

