/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.license;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.diagnostics.DiagnosticsRegistry;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LicenseKeyTelemetryTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    ProcessEngine processEngine;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    ManagementService managementService;
    DiagnosticsRegistry telemetryRegistry;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.telemetryRegistry = this.processEngineConfiguration.getDiagnosticsRegistry();
    }

    @After
    public void tearDown() {
        this.managementService.deleteLicenseKey();
        this.telemetryRegistry.clear();
    }

    @Test
    public void shouldSetLicenseKeyInTelemetryRegistry() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((String)this.telemetryRegistry.getLicenseKey().getRaw()).isEqualTo((Object)licenseKey);
    }

    @Test
    public void shouldNotOverrideSameLicenseKeyInTelemetryRegistry() {
        String licenseKey = "testLicenseKey";
        LicenseKeyDataImpl licenseKeyData = new LicenseKeyDataImpl("customer", null, null, null, null, licenseKey);
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isEqualTo((Object)licenseKeyData);
    }

    @Test
    public void shouldNotOverrideSameMultipartLicenseKeyInTelemetryRegistry() {
        String licenseKey = "signature;testLicenseKey;more;data";
        LicenseKeyDataImpl licenseKeyData = new LicenseKeyDataImpl("customer", null, null, null, null, "testLicenseKey;more;data");
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.setLicenseKey(licenseKey);
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isEqualTo((Object)licenseKeyData);
    }

    @Test
    public void shouldRemoveLicenseKeyFromTelemetryRegistry() {
        LicenseKeyDataImpl licenseKeyData = new LicenseKeyDataImpl("customer", null, null, null, null, "testLicenseKey");
        this.telemetryRegistry.setLicenseKey(licenseKeyData);
        this.managementService.deleteLicenseKey();
        Assertions.assertThat((Object)this.telemetryRegistry.getLicenseKey()).isNull();
    }
}

