/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mgmt.metrics;

import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ActivityInstanceCountMetricsTest
extends AbstractMetricsTest {
    @Test
    public void testBpmnActivityInstances() {
        this.testRule.deploy(((ProcessBuilder)Bpmn.createExecutableProcess((String)"testProcess").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().manualTask().endEvent().done());
        Assert.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        Assert.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("flow-node-instances").sum());
    }

    @Test
    public void testStandaloneTask() {
        Assert.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.taskService.deleteTask(task.getId());
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        if (hti != null) {
            this.historyService.deleteHistoricTaskInstance(hti.getId());
        }
    }

    @Deployment
    @Test
    public void testCmmnActivitiyInstances() {
        Assert.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.caseService.createCaseInstanceByKey("case");
        Assert.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        List list = this.caseService.createCaseExecutionQuery().enabled().list();
        for (CaseExecution caseExecution : list) {
            this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        }
        Assert.assertEquals((long)2L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)2L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.completeCaseExecution(taskExecution.getId());
        Assert.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }
}

