/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.mock;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.mock.Mocks;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MocksTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    public void testMethodsOfMocksAPI() {
        HashMap<CallSite, Object> map = new HashMap<CallSite, Object>();
        for (int i = 0; i < 5; ++i) {
            map.put((CallSite)((Object)("key" + i)), new Object());
        }
        for (String key : map.keySet()) {
            Mocks.register((String)key, map.get(key));
        }
        for (String key : map.keySet()) {
            TestCase.assertEquals(map.get(key), (Object)Mocks.get((Object)key));
        }
        TestCase.assertEquals(map, (Object)Mocks.getMocks());
        Mocks.reset();
        for (String key : map.keySet()) {
            TestCase.assertNull((Object)Mocks.get((Object)key));
        }
        TestCase.assertEquals((int)0, (int)Mocks.getMocks().size());
    }

    @Test
    @Deployment
    public void testMockAvailabilityInScriptTask() {
        this.testMockAvailability();
    }

    @Test
    @Deployment
    public void testMockAvailabilityInExpressionLanguage() {
        this.testMockAvailability();
    }

    private void testMockAvailability() {
        Mocks.register((String)"myMock", (Object)new MyPojo());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("mocksTest");
        Mocks.reset();
        TestCase.assertEquals((Object)"testValue", (Object)this.runtimeService.getVariable(pi.getId(), "testVar"));
    }

    public static class MyPojo {
        public String test = "testValue";

        public String getTest() {
            return this.test;
        }

        public void testMethod(DelegateExecution execution, String str) {
            execution.setVariable("testVar", (Object)str);
        }
    }
}

