/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyCallActivityTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String CMMN = "org/eximeebpms/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
    protected static final BpmnModelInstance SUB_PROCESS = Bpmn.createExecutableProcess((String)"subProcess").startEvent().userTask().endEvent().done();

    @Test
    public void testStartProcessInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessDefinition latestSubProcessTenantTwo = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).processDefinitionKey("subProcess").latestVersion().singleResult();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).processDefinitionId(latestSubProcessTenantTwo.getId()).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("1")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS, callingProcess);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceWithVersionTagBinding() {
        BpmnModelInstance callingProcess = this.createCallingProcess("callingProcess", "ver_tag_1");
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_ONE, "org/eximeebpms/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml");
        this.testRule.deployForTenant(TENANT_TWO, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, "org/eximeebpms/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag2.bpmn20.xml");
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.activityIdIn(new String[]{"Task_1"}).tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.activityIdIn(new String[]{"Task_2"}).tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key = 'subProcess'"});
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key 'subProcess'"});
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("version")).camundaCalledElementVersion("2")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SUB_PROCESS);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key = 'subProcess'"});
        }
    }

    @Test
    public void testFailStartProcessInstanceFromOtherTenantWithVersionTagBinding() {
        BpmnModelInstance callingProcess = this.createCallingProcess("callingProcess", "ver_tag_2");
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, "org/eximeebpms/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag2.bpmn20.xml");
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no processes deployed with key = 'subProcess'"});
        }
    }

    @Test
    public void testStartCaseInstanceWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingSameVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testStartCaseInstanceWithLatestBindingDifferentVersion() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        CaseDefinition latestCaseDefinitionTenantTwo = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).latestVersion().singleResult();
        query = this.caseService.createCaseInstanceQuery().caseDefinitionId(latestCaseDefinitionTenantTwo.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testStartCaseInstanceWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("1")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, callingProcess, CMMN);
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_TWO).execute();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("deployment")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no case definition deployed with key = 'Case_1'"});
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithLatestBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("latest")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no case definition deployed with key 'Case_1'"});
        }
    }

    @Test
    public void testFailStartCaseInstanceFromOtherTenantWithVersionBinding() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseBinding("version")).camundaCaseVersion("2")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, callingProcess, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        this.testRule.deployForTenant(TENANT_TWO, CMMN);
        try {
            this.runtimeService.createProcessInstanceByKey("callingProcess").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no case definition deployed with key = 'Case_1'"});
        }
    }

    @Test
    public void testCalledElementTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId(TENANT_ONE)).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCalledElementTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("subProcess")).camundaCalledElementTenantId("${'tenant1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, SUB_PROCESS);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCaseRefTenantIdConstant() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId(TENANT_ONE)).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCaseRefTenantIdExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId("${'tenant1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCaseRefTenantIdCompositeExpression() {
        BpmnModelInstance callingProcess = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().camundaCaseRef("Case_1")).camundaCaseTenantId("tenant${'1'}")).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, CMMN);
        this.testRule.deploy(callingProcess);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().caseDefinitionKey("Case_1");
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    protected BpmnModelInstance createCallingProcess(String processId, String versionTagValue) {
        return ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().callActivity().calledElement("subProcess")).camundaCalledElementBinding("versionTag")).camundaCalledElementVersionTag(versionTagValue)).endEvent().done();
    }
}

