/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.MismatchingMessageCorrelationException;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMessageCorrelationTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance MESSAGE_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"messageStart").startEvent().message("message")).userTask().endEvent().done();
    protected static final BpmnModelInstance MESSAGE_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"messageCatch").startEvent().intermediateCatchEvent().message("message")).userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void correlateMessageToStartEventNoTenantIdSetForNonTenant() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((ProcessInstance)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void correlateMessageToStartEventNoTenantIdSetForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void correlateMessageToStartEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((ProcessInstance)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void correlateMessageToStartEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void correlateMessageToIntermediateCatchEventNoTenantIdSetForNonTenant() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("messageCatch");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void correlateMessageToIntermediateCatchEventNoTenantIdSetForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("messageCatch");
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void correlateMessageToIntermediateCatchEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((Task)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void correlateMessageToIntermediateCatchEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlate();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.engineRule.getTaskService().createTaskQuery().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
        Assertions.assertThat((String)((Task)tasks.get(0)).getTenantId()).isNull();
        Assertions.assertThat((String)((Task)tasks.get(1)).getTenantId()).isNull();
    }

    @Test
    public void correlateMessageToStartAndIntermediateCatchEventWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void correlateMessageToMultipleIntermediateCatchEventsWithoutTenantId() {
        this.testRule.deploy(MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionWithoutTenantId().execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateAll();
        List tasks = this.engineRule.getTaskService().createTaskQuery().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
        Assertions.assertThat((String)((Task)tasks.get(0)).getTenantId()).isNull();
        Assertions.assertThat((String)((Task)tasks.get(1)).getTenantId()).isNull();
    }

    @Test
    public void correlateMessageToMultipleIntermediateCatchEventsWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void correlateStartMessageWithoutTenantId() {
        this.testRule.deploy(MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").withoutTenantId().correlateStartMessage();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((ProcessInstance)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void correlateStartMessageWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").tenantId(TENANT_ONE).correlateStartMessage();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void correlateMessagesToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void correlateMessagesToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        TaskQuery query = this.engineRule.getTaskService().createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void correlateMessagesToStartAndIntermediateCatchEventForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateAll();
        Assertions.assertThat((long)this.engineRule.getRuntimeService().createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)this.engineRule.getTaskService().createTaskQuery().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    public void failToCorrelateMessageToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_CATCH_PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("messageCatch").processDefinitionTenantId(TENANT_TWO).execute();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate()).isInstanceOf(MismatchingMessageCorrelationException.class)).hasMessageContaining("Cannot correlate a message with name 'message' to a single execution");
    }

    @Test
    public void testSubscriptionsWhenDeletingGroupsProcessDefinitionsByIds() {
        String processDefId1 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId2 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId3 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, MESSAGE_START_PROCESS).getId();
        String processDefId4 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        String processDefId5 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        String processDefId6 = this.testRule.deployAndGetDefinition(MESSAGE_START_PROCESS).getId();
        BpmnModelInstance processAnotherKey = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"anotherKey").startEvent().message("sophisticated message")).userTask().endEvent().done();
        String processDefId7 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId8 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        String processDefId9 = this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, processAnotherKey).getId();
        Assert.assertEquals((long)3L, (long)this.engineRule.getRuntimeService().createEventSubscriptionQuery().count());
        this.engineRule.getRepositoryService().deleteProcessDefinitions().byIds(new String[]{processDefId8, processDefId5, processDefId3, processDefId9, processDefId1}).delete();
        List list = this.engineRule.getRuntimeService().createEventSubscriptionQuery().list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (EventSubscription eventSubscription : list) {
            EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)eventSubscription;
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId2)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId6)) {
                Assert.assertEquals(null, (Object)eventSubscription.getTenantId());
                continue;
            }
            if (eventSubscriptionEntity.getConfiguration().equals(processDefId7)) {
                Assert.assertEquals((Object)TENANT_ONE, (Object)eventSubscription.getTenantId());
                continue;
            }
            Assert.fail((String)("This process definition '" + eventSubscriptionEntity.getConfiguration() + "' and the respective event subscription should not exist."));
        }
    }

    @Test
    public void failToCorrelateMessageToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").correlate()).isInstanceOf(MismatchingMessageCorrelationException.class)).hasMessageContaining("Cannot correlate a message with name 'message' to a single process definition");
    }

    @Test
    public void failToCorrelateStartMessageForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, MESSAGE_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, MESSAGE_START_PROCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").correlateStartMessage()).isInstanceOf(MismatchingMessageCorrelationException.class)).hasMessageContaining("Cannot correlate a message with name 'message' to a single process definition");
    }

    @Test
    public void failToCorrelateMessageByProcessInstanceIdWithoutTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").processInstanceId("id").withoutTenantId().correlate()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot specify a tenant-id");
    }

    @Test
    public void failToCorrelateMessageByProcessInstanceIdAndTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").processInstanceId("id").tenantId(TENANT_ONE).correlate()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot specify a tenant-id");
    }

    @Test
    public void failToCorrelateMessageByProcessDefinitionIdWithoutTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").processDefinitionId("id").withoutTenantId().correlateStartMessage()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot specify a tenant-id");
    }

    @Test
    public void failToCorrelateMessageByProcessDefinitionIdAndTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation("message").processDefinitionId("id").tenantId(TENANT_ONE).correlateStartMessage()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot specify a tenant-id");
    }
}

