/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySharedDefinitionPropagationTest {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String TENANT_ID = "tenant1";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(TENANT_ID);
        configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
    });
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void propagateTenantIdToProcessInstance() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void propagateTenantIdToIntermediateTimerJob() {
        this.testRule.deploy(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().timerWithDuration("PT1M")).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ID);
    }

    @Test
    public void propagateTenantIdToAsyncJob() {
        this.testRule.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaAsyncBefore()).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ID);
    }
}

