/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.EndEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySignalReceiveTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance SIGNAL_START_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"signalStart").startEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_CATCH_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"signalCatch").startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    protected static final BpmnModelInstance SIGNAL_INTERMEDIATE_THROW_PROCESS = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().intermediateThrowEvent().signal("signal")).endEvent().done();
    protected static final BpmnModelInstance SIGNAL_END_THROW_PROCESS = ((EndEventBuilder)Bpmn.createExecutableProcess((String)"signalThrow").startEvent().endEvent().signal("signal")).done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void sendSignalToStartEventForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((ProcessInstance)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void sendSignalToStartEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToStartEventWithoutTenantIdForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS);
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToStartEventWithoutTenantIdForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToIntermediateCatchEventForNonTenant() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((Task)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void sendSignalToIntermediateCatchEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithoutTenantIdForNonTenant() {
        this.testRule.deploy(SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToIntermediateCatchEventWithoutTenantIdForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createSignalEvent("signal").withoutTenantId().send();
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
        Assertions.assertThat((String)((Task)tasks.get(0)).getTenantId()).isNull();
        Assertions.assertThat((String)((Task)tasks.get(1)).getTenantId()).isNull();
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_ONE).send();
        this.runtimeService.createSignalEvent("signal").tenantId(TENANT_TWO).send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void sendSignalToStartEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.runtimeService.createSignalEvent("signal").send();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToIntermediateCatchEventsForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void sendSignalToStartAndIntermediateCatchEventForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_CATCH_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").execute();
        this.runtimeService.createSignalEvent("signal").send();
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void failToSendSignalWithExecutionIdForTenant() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createSignalEvent("signal").executionId("id").tenantId(TENANT_ONE).send()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Cannot specify a tenant-id when deliver a signal to a single execution.");
    }

    @Test
    public void throwIntermediateSignalForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void throwIntermediateSignalForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_INTERMEDIATE_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
    }

    @Test
    public void throwEndSignalForTenant() {
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_TWO).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void throwEndSignalForNonTenant() {
        this.testRule.deploy(SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS, SIGNAL_END_THROW_PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, SIGNAL_START_PROCESS, SIGNAL_CATCH_PROCESS);
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionWithoutTenantId().execute();
        this.runtimeService.createProcessInstanceByKey("signalCatch").processDefinitionTenantId(TENANT_ONE).execute();
        this.runtimeService.startProcessInstanceByKey("signalThrow");
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
    }
}

