/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyTimerStartEventTest {
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess().startEvent().timerWithDuration("PT1M")).userTask().endEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void startProcessInstanceWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ONE);
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void startProcessInstanceTwoTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        Job jobForTenantOne = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assertions.assertThat((Object)jobForTenantOne).isNotNull();
        this.managementService.executeJob(jobForTenantOne.getId());
        Job jobForTenantTwo = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult();
        Assertions.assertThat((Object)jobForTenantTwo).isNotNull();
        this.managementService.executeJob(jobForTenantTwo.getId());
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void deleteJobsWhileUndeployment() {
        Deployment deploymentForTenantOne = this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        Deployment deploymentForTenantTwo = this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        JobQuery query = this.managementService.createJobQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        this.repositoryService.deleteDeployment(deploymentForTenantOne.getId(), true);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        this.repositoryService.deleteDeployment(deploymentForTenantTwo.getId(), true);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
    }

    @Test
    public void dontCreateNewJobsWhileReDeployment() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        JobQuery query = this.managementService.createJobQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void failedJobRetryTimeCycle() {
        this.testRule.deployForTenant(TENANT_ONE, ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().timerWithDuration("PT1M")).camundaFailedJobRetryTimeCycle("R5/PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        this.testRule.deployForTenant(TENANT_TWO, ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().timerWithDuration("PT1M")).camundaFailedJobRetryTimeCycle("R4/PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        List jobs = this.managementService.createJobQuery().timers().list();
        this.executeFailingJobs(jobs);
        Job jobTenantOne = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Job jobTenantTwo = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult();
        Assertions.assertThat((int)jobTenantOne.getRetries()).isEqualTo(4);
        Assertions.assertThat((int)jobTenantTwo.getRetries()).isEqualTo(3);
    }

    @Test
    public void timerStartEventWithTimerCycle() {
        this.testRule.deployForTenant(TENANT_ONE, ((StartEventBuilder)Bpmn.createExecutableProcess().startEvent().timerWithCycle("R2/PT1M")).userTask().endEvent().done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ONE);
        this.managementService.executeJob(job.getId());
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((String)job.getTenantId()).isEqualTo((Object)TENANT_ONE);
        this.managementService.executeJob(job.getId());
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(0L);
    }

    protected void executeFailingJobs(List<Job> jobs) {
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
                Assert.fail((String)"expected exception");
            }
            catch (Exception exception) {}
        }
    }
}

