/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyCreateCaseInstanceTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CASE_DEFINITION_KEY = "oneTaskCase";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Test
    public void testFailToCreateCaseInstanceByIdWithoutTenantId() {
        this.testRule.deploy(CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionWithoutTenantId().create();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot specify a tenant-id"});
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByIdWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).caseDefinitionTenantId(TENANT_ONE).create();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot specify a tenant-id"});
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyForNonExistingTenantID() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId("nonExistingTenantId").create();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no case definition deployed with key 'oneTaskCase' and tenant-id 'nonExistingTenantId'"});
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"multiple tenants."});
        }
    }

    @Test
    public void testCreateCaseInstanceByKeyWithoutTenantId() {
        this.testRule.deploy(CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((String)((CaseInstance)query.singleResult()).getTenantId()).isNull();
    }

    @Test
    public void testCreateCaseInstanceByKeyForAnyTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        Assertions.assertThat((long)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCreateCaseInstanceByKeyAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        Assertions.assertThat((long)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCreateCaseInstanceByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deploy(CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionWithoutTenantId().create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no case definition deployed with key 'oneTaskCase'"});
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        try {
            this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot create an instance of the case definition"});
        }
    }

    @Test
    public void testFailToCreateCaseInstanceByIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.caseService.withCaseDefinition(caseDefinition.getId()).create();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot create an instance of the case definition"});
        }
    }

    @Test
    public void testCreateCaseInstanceByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCreateCaseInstanceByIdAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.withCaseDefinition(caseDefinition.getId()).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCreateCaseInstanceByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void testCreateCaseInstanceByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).caseDefinitionTenantId(TENANT_ONE).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }
}

