/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn.query;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyCaseExecutionQueryTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(CMMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.createCaseInstance(null);
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    @Test
    public void testQueryByTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByTenantIds() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
    }

    @Test
    public void testQueryByExecutionsWithoutTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List caseExecutions = ((CaseExecutionQuery)this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)caseExecutions).hasSize(4);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(2)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(3)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List caseExecutions = ((CaseExecutionQuery)this.caseService.createCaseExecutionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)caseExecutions).hasSize(4);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(2)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((CaseExecution)caseExecutions.get(3)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    protected CaseInstance createCaseInstance(String tenantId) {
        String caseDefinitionId = null;
        CaseDefinitionQuery caseDefinitionQuery = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase");
        caseDefinitionId = tenantId == null ? ((CaseDefinition)caseDefinitionQuery.withoutTenantId().singleResult()).getId() : ((CaseDefinition)caseDefinitionQuery.tenantIdIn(new String[]{tenantId}).singleResult()).getId();
        return this.caseService.withCaseDefinition(caseDefinitionId).create();
    }
}

