/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.cmmn.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstance;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricCaseInstanceQueryTest {
    protected static final String CMMN_FILE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected CaseService caseService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.caseService = this.engineRule.getCaseService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deploy(CMMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_FILE);
        this.caseService.withCaseDefinitionByKey("oneTaskCase").caseDefinitionWithoutTenantId().create();
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    @Test
    public void shouldQueryNoTenantIdSet() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByInstancesWithoutTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicCaseInstances = ((HistoricCaseInstanceQuery)this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicCaseInstances.size()).isEqualTo(2);
        Assertions.assertThat((String)((HistoricCaseInstance)historicCaseInstances.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((HistoricCaseInstance)historicCaseInstances.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicCaseInstances = ((HistoricCaseInstanceQuery)this.historyService.createHistoricCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicCaseInstances.size()).isEqualTo(2);
        Assertions.assertThat((String)((HistoricCaseInstance)historicCaseInstances.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((HistoricCaseInstance)historicCaseInstances.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected void createCaseInstance(String tenantId) {
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("oneTaskCase");
        builder.caseDefinitionTenantId(tenantId).create();
    }
}

