/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyProcessDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_DEFINITION_KEY = "process";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess((String)"process").startEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_TWO, emptyProcess);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeProcessDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)processDefinitionsForTenant.get(null).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)processDefinition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)processDefinition.getVersion()).isEqualTo(2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        processDefinition = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)processDefinition.getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((int)processDefinition.getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithoutTenantId() {
        this.testRule.deploy(emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        ProcessDefinition processDefinition = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)processDefinition.getTenantId()).isNull();
        Assertions.assertThat((int)processDefinition.getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, ProcessDefinition> processDefinitionsForTenant = this.getProcessDefinitionsForTenant(query.list());
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(3);
        Assertions.assertThat((int)processDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)processDefinitionsForTenant.get(null).getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)processDefinitions).hasSize(2);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)processDefinitions).hasSize(2);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    protected Map<String, ProcessDefinition> getProcessDefinitionsForTenant(List<ProcessDefinition> processDefinitions) {
        HashMap<String, ProcessDefinition> definitionsForTenant = new HashMap<String, ProcessDefinition>();
        for (ProcessDefinition definition : processDefinitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeProcessDefinitionsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }
}

