/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.management.ActivityStatisticsQuery;
import org.eximeebpms.bpm.engine.management.DeploymentStatistics;
import org.eximeebpms.bpm.engine.management.DeploymentStatisticsQuery;
import org.eximeebpms.bpm.engine.management.ProcessDefinitionStatistics;
import org.eximeebpms.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyStatisticsQueryTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"EmptyProcess").startEvent().done();
        BpmnModelInstance singleTaskProcess = Bpmn.createExecutableProcess((String)"SingleTaskProcess").startEvent().userTask().done();
        this.testRule.deploy(process);
        this.testRule.deployForTenant(TENANT_ONE, singleTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, process);
    }

    @Test
    public void testDeploymentStatistics() {
        List deploymentStatistics = this.managementService.createDeploymentStatisticsQuery().list();
        Assertions.assertThat((List)deploymentStatistics).hasSize(3);
        Set<String> tenantIds = this.collectDeploymentTenantIds(deploymentStatistics);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testProcessDefinitionStatistics() {
        List processDefinitionStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assertions.assertThat((List)processDefinitionStatistics).hasSize(3);
        Set<String> tenantIds = this.collectDefinitionTenantIds(processDefinitionStatistics);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testQueryNoAuthenticatedTenantsForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, null);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(1);
        Assertions.assertThat((String)tenantIds.iterator().next()).isNull();
    }

    @Test
    public void testQueryAuthenticatedTenantForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(2);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE});
    }

    @Test
    public void testQueryAuthenticatedTenantsForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(3);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testQueryDisabledTenantCheckForDeploymentStatistics() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(3);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testQueryNoAuthenticatedTenantsForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(1);
        Assertions.assertThat((String)tenantIds.iterator().next()).isNull();
    }

    @Test
    public void testQueryAuthenticatedTenantForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(2);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE});
    }

    @Test
    public void testQueryAuthenticatedTenantsForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(3);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testQueryDisabledTenantCheckForProcessDefinitionStatistics() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assertions.assertThat(tenantIds).hasSize(3);
        Assertions.assertThat(tenantIds).contains((Object[])new String[]{null, TENANT_ONE, TENANT_TWO});
    }

    @Test
    public void testActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenantForActivityStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryNoAuthenticatedTenantForActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        this.identityService.setAuthentication("user", null);
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testQueryDisabledTenantCheckForActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        this.identityService.setAuthentication("user", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    protected Set<String> collectDeploymentTenantIds(List<DeploymentStatistics> deploymentStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (DeploymentStatistics statistics : deploymentStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }

    protected Set<String> collectDefinitionTenantIds(List<ProcessDefinitionStatistics> processDefinitionStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (ProcessDefinitionStatistics statistics : processDefinitionStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }
}

