/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDecisionInstanceQueryTest {
    protected static final String DMN = "org/eximeebpms/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.decisionService = this.engineRule.getDecisionService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_NULL, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        this.evaluateDecisionInstance();
        this.evaluateDecisionInstanceForTenant(TENANT_ONE);
        this.evaluateDecisionInstanceForTenant(TENANT_TWO);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    public void shouldQueryByNonExistingTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDecisionInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicDecisionInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicDecisionInstances, TestOrderingUtil.historicDecisionInstanceByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicDecisionInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicDecisionInstances, TestOrderingUtil.inverted(TestOrderingUtil.historicDecisionInstanceByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    protected void evaluateDecisionInstanceForTenant(String tenant) {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{tenant}).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze");
        this.decisionService.evaluateDecisionTableById(decisionDefinitionId, (Map)variables);
    }

    protected void evaluateDecisionInstance() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().withoutTenantId().singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze");
        this.decisionService.evaluateDecisionTableById(decisionDefinitionId, (Map)variables);
    }
}

