/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query.history;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class MultiTenancyHistoricProcessInstanceStateTest {
    public static final String PROCESS_ID = "process1";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);

    @Test
    public void testSuspensionWithTenancy() throws Exception {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().endEvent().done();
        ProcessDefinition processDefinition = this.processEngineTestRule.deployAndGetDefinition(instance);
        ProcessDefinition processDefinition1 = this.processEngineTestRule.deployForTenantAndGetDefinition(TENANT_ONE, instance);
        ProcessDefinition processDefinition2 = this.processEngineTestRule.deployForTenantAndGetDefinition(TENANT_TWO, instance);
        ProcessInstance processInstance = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId());
        ProcessInstance processInstance1 = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition1.getId());
        ProcessInstance processInstance2 = this.processEngineRule.getRuntimeService().startProcessInstanceById(processDefinition2.getId());
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinition1.getKey()).processDefinitionTenantId(processDefinition1.getTenantId()).suspend();
        String[] processInstances = new String[]{processInstance1.getId(), processInstance2.getId(), processInstance.getId()};
        this.verifyStates(processInstances, new String[]{"SUSPENDED", "ACTIVE", "ACTIVE"});
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinition.getKey()).processDefinitionWithoutTenantId().suspend();
        this.verifyStates(processInstances, new String[]{"SUSPENDED", "ACTIVE", "SUSPENDED"});
        this.processEngineRule.getRuntimeService().updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinition.getKey()).processDefinitionWithoutTenantId().activate();
        this.verifyStates(processInstances, new String[]{"SUSPENDED", "ACTIVE", "ACTIVE"});
    }

    protected void verifyStates(String[] processInstances, String[] states) {
        for (int i = 0; i < processInstances.length; ++i) {
            Assertions.assertThat((String)((HistoricProcessInstance)this.processEngineRule.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstances[i]).singleResult()).getState()).isEqualTo((Object)states[i]);
        }
    }
}

