/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MultiTenancyCommandTenantCheckTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.identityService.setAuthentication("user", null, null);
    }

    @Test
    public void disableTenantCheckForProcessEngine() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.enableTenantCheck();
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isFalse();
                return null;
            }
        });
    }

    @Test
    public void disableTenantCheckForCommand() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.disableTenantCheck();
                Assertions.assertThat((boolean)commandContext.isTenantCheckEnabled()).isFalse();
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isFalse();
                return null;
            }
        });
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Assertions.assertThat((boolean)commandContext.isTenantCheckEnabled()).isTrue();
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isTrue();
                return null;
            }
        });
    }

    @Test
    public void disableAndEnableTenantCheckForCommand() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.disableTenantCheck();
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isFalse();
                commandContext.enableTenantCheck();
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isTrue();
                return null;
            }
        });
    }

    @Test
    public void disableTenantCheckForCamundaAdmin() {
        this.identityService.setAuthentication("user", Collections.singletonList("eximeebpms-admin"), null);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Assertions.assertThat((boolean)commandContext.getTenantManager().isTenantCheckEnabled()).isFalse();
                return null;
            }
        });
    }
}

