/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.dmn.DmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDecisionDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DMN_MODEL = "org/eximeebpms/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String decisionDefinitionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetDecisionModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionModel(this.decisionDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision definition");
    }

    @Test
    public void getDecisionModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionModel(this.decisionDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getDecisionModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionModel(this.decisionDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void failToGetDecisionDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionDiagram(this.decisionDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision definition");
    }

    @Test
    public void getDecisionDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionDiagram(this.decisionDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNull();
    }

    @Test
    public void getDecisionDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionDiagram(this.decisionDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNull();
    }

    @Test
    public void failToGetDecisionDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionDefinition(this.decisionDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision definition");
    }

    @Test
    public void getDecisionDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void getDecisionDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void failToGetDmnModelInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDmnModelInstance(this.decisionDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision definition");
    }

    @Test
    public void updateHistoryTimeToLiveWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(this.decisionDefinitionId, Integer.valueOf(6));
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((Integer)definition.getHistoryTimeToLive()).isEqualTo(6);
    }

    @Test
    public void updateHistoryTimeToLiveDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(this.decisionDefinitionId, Integer.valueOf(6));
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((Integer)definition.getHistoryTimeToLive()).isEqualTo(6);
    }

    @Test
    public void updateHistoryTimeToLiveNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(this.decisionDefinitionId, Integer.valueOf(6))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the decision definition");
    }

    @Test
    public void getDmnModelInstanceWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(this.decisionDefinitionId);
        Assertions.assertThat((Object)modelInstance).isNotNull();
    }

    @Test
    public void getDmnModelInstanceDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(this.decisionDefinitionId);
        Assertions.assertThat((Object)modelInstance).isNotNull();
    }
}

