/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyExecutionVariableCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String VARIABLE_1 = "testVariable1";
    protected static final String VARIABLE_2 = "testVariable2";
    protected static final String VARIABLE_VALUE_1 = "test1";
    protected static final String VARIABLE_VALUE_2 = "test2";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected String processInstanceId;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.processInstanceId = this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)Variables.createVariables().putValue(VARIABLE_1, (Object)VARIABLE_VALUE_1).putValue(VARIABLE_2, (Object)VARIABLE_VALUE_2)).getId();
    }

    @Test
    public void getExecutionVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getRuntimeService().getVariable(this.processInstanceId, VARIABLE_1));
    }

    @Test
    public void getExecutionVariableWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().getVariable(this.processInstanceId, VARIABLE_1)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getExecutionVariableWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getRuntimeService().getVariable(this.processInstanceId, VARIABLE_1));
    }

    @Test
    public void getExecutionVariableTypedWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getRuntimeService().getVariableTyped(this.processInstanceId, VARIABLE_1).getValue());
    }

    @Test
    public void getExecutionVariableTypedWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().getVariableTyped(this.processInstanceId, VARIABLE_1)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getExecutionVariableTypedWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((Object)VARIABLE_VALUE_1, (Object)this.engineRule.getRuntimeService().getVariableTyped(this.processInstanceId, VARIABLE_1).getValue());
    }

    @Test
    public void getExecutionVariablesWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((long)2L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }

    @Test
    public void getExecutionVariablesWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getExecutionVariablesWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assert.assertEquals((long)2L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }

    @Test
    public void setExecutionVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().setVariable(this.processInstanceId, "newVariable", (Object)"newValue");
        Assert.assertEquals((long)3L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }

    @Test
    public void setExecutionVariableWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().setVariable(this.processInstanceId, "newVariable", (Object)"newValue")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void setExecutionVariableWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getRuntimeService().setVariable(this.processInstanceId, "newVariable", (Object)"newValue");
        Assert.assertEquals((long)3L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }

    @Test
    public void removeExecutionVariableWithAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().removeVariable(this.processInstanceId, VARIABLE_1);
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }

    @Test
    public void removeExecutionVariableWithNoAuthenticatedTenant() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().removeVariable(this.processInstanceId, VARIABLE_1)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the process instance '" + this.processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void removeExecutionVariableWithDisabledTenantCheck() {
        this.engineRule.getIdentityService().setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getRuntimeService().removeVariable(this.processInstanceId, VARIABLE_1);
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().getVariables(this.processInstanceId).size());
    }
}

