/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricJobLog;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceBuilder;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDataCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "failingProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static final BpmnModelInstance BPMN_PROCESS = Bpmn.createExecutableProcess((String)"failingProcess").startEvent().endEvent().done();
    protected static final BpmnModelInstance BPMN_ONETASK_PROCESS = Bpmn.createExecutableProcess((String)"failingProcess").startEvent().userTask("task1").moveToActivity("task1").endEvent().done();
    protected static final BpmnModelInstance FAILING_BPMN_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().serviceTask().camundaExpression("${failing}")).camundaAsyncBefore()).endEvent().done();
    protected static final String CMMN_PROCESS_WITH_MANUAL_ACTIVATION = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn";
    protected static final String DMN = "org/eximeebpms/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (HistoricTaskInstance instance : this.historyService.createHistoricTaskInstanceQuery().list()) {
            this.historyService.deleteHistoricTaskInstance(instance.getId());
        }
    }

    @Test
    public void failToDeleteHistoricProcessInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricProcessInstance(processInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("No historic process instance found");
    }

    @Test
    public void deleteHistoricProcessInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.identityService.clearAuthentication();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricProcessInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_PROCESS);
        String processInstanceIdOne = this.startProcessInstance(TENANT_ONE);
        String processInstanceIdTwo = this.startProcessInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricProcessInstance(processInstanceIdOne);
        this.historyService.deleteHistoricProcessInstance(processInstanceIdTwo);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void failToDeleteHistoricTaskInstanceNoAuthenticatedTenants() {
        String taskId = this.createTaskForTenant(TENANT_ONE);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricTaskInstance(taskId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the historic task instance");
    }

    @Test
    public void deleteHistoricTaskInstanceWithAuthenticatedTenant() {
        String taskId = this.createTaskForTenant(TENANT_ONE);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.identityService.clearAuthentication();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricTaskInstanceWithDisabledTenantCheck() {
        String taskIdOne = this.createTaskForTenant(TENANT_ONE);
        String taskIdTwo = this.createTaskForTenant(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricTaskInstance(taskIdOne);
        this.historyService.deleteHistoricTaskInstance(taskIdTwo);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void failToDeleteHistoricCaseInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceId = this.createAndCloseCaseInstance(null);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricCaseInstance(caseInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the historic case instance");
    }

    @Test
    public void deleteHistoricCaseInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceId = this.createAndCloseCaseInstance(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricCaseInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_PROCESS_WITH_MANUAL_ACTIVATION);
        String caseInstanceIdOne = this.createAndCloseCaseInstance(TENANT_ONE);
        String caseInstanceIdTwo = this.createAndCloseCaseInstance(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricCaseInstance(caseInstanceIdOne);
        this.historyService.deleteHistoricCaseInstance(caseInstanceIdTwo);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricDecisionInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        String decisionDefinitionId = this.evaluateDecisionTable(null);
        this.identityService.setAuthentication("user", null, null);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.identityService.clearAuthentication();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void deleteHistoricDecisionInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        String decisionDefinitionId = this.evaluateDecisionTable(null);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.identityService.clearAuthentication();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricDecisionInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        String decisionDefinitionIdOne = this.evaluateDecisionTable(TENANT_ONE);
        String decisionDefinitionIdTwo = this.evaluateDecisionTable(TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionIdOne);
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionIdTwo);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void failToDeleteHistoricDecisionInstanceByInstanceIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.evaluateDecisionTable(null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the historic decision instance");
    }

    @Test
    public void deleteHistoricDecisionInstanceByInstanceIdWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.evaluateDecisionTable(null);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void deleteHistoricDecisionInstanceByInstanceIdWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
        this.evaluateDecisionTable(TENANT_ONE);
        this.evaluateDecisionTable(TENANT_TWO);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        List historicDecisionInstances = query.includeInputs().includeOutputs().list();
        Assertions.assertThat((int)historicDecisionInstances.size()).isEqualTo(2);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        for (HistoricDecisionInstance in : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(in.getId());
        }
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void failToGetHistoricJobLogExceptionStacktraceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        String historicJobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.getHistoricJobLogExceptionStacktrace(historicJobLogId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the historic job log");
    }

    @Test
    public void getHistoricJobLogExceptionStacktraceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.testRule.executeAvailableJobs();
        HistoricJobLog log = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).failureLog().listPage(0, 1).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        String historicJobLogExceptionStacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(log.getId());
        Assertions.assertThat((String)historicJobLogExceptionStacktrace).isNotNull();
    }

    @Test
    public void getHistoricJobLogExceptionStacktraceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, FAILING_BPMN_PROCESS);
        String processInstanceId = this.startProcessInstance(TENANT_ONE);
        this.testRule.executeAvailableJobs();
        HistoricJobLog log = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).failureLog().listPage(0, 1).get(0);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        String historicJobLogExceptionStacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(log.getId());
        Assertions.assertThat((String)historicJobLogExceptionStacktrace).isNotNull();
    }

    @Test
    public void failToDeleteHistoricVariableInstanceNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try {
                this.historyService.deleteHistoricVariableInstance(variableInstanceId);
            }
            catch (Throwable throwable) {
                this.cleanUpAfterVariableInstanceTest(processInstanceId);
                throw throwable;
            }
            this.cleanUpAfterVariableInstanceTest(processInstanceId);
        }).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the historic variable instance '" + variableInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteHistoricVariableInstanceWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue");
        HistoricVariableInstanceQuery variableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId);
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(1L);
        String variableInstanceId = ((HistoricVariableInstance)variableQuery.singleResult()).getId();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(0L);
        this.cleanUpAfterVariableInstanceTest(processInstanceId);
    }

    @Test
    public void deleteHistoricVariableInstanceWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_ONETASK_PROCESS);
        String processInstanceIdOne = this.startProcessInstance(TENANT_ONE);
        String processInstanceIdTwo = this.startProcessInstance(TENANT_TWO);
        this.runtimeService.setVariable(processInstanceIdOne, "myVariable", (Object)"testValue");
        this.runtimeService.setVariable(processInstanceIdTwo, "myVariable", (Object)"testValue");
        HistoricVariableInstanceQuery variableQueryOne = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceIdOne);
        HistoricVariableInstanceQuery variableQueryTwo = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceIdTwo);
        Assertions.assertThat((long)variableQueryOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)variableQueryTwo.count()).isEqualTo(1L);
        String variableInstanceIdOne = ((HistoricVariableInstance)variableQueryOne.singleResult()).getId();
        String variableInstanceIdTwo = ((HistoricVariableInstance)variableQueryTwo.singleResult()).getId();
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricVariableInstance(variableInstanceIdOne);
        this.historyService.deleteHistoricVariableInstance(variableInstanceIdTwo);
        Assertions.assertThat((long)variableQueryOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)variableQueryTwo.count()).isEqualTo(0L);
        this.cleanUpAfterVariableInstanceTest(processInstanceIdOne, processInstanceIdTwo);
    }

    @Test
    public void failToDeleteHistoricVariableInstancesNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue");
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue2");
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try {
                this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
            }
            catch (Throwable throwable) {
                this.cleanUpAfterVariableInstanceTest(processInstanceId);
                throw throwable;
            }
            this.cleanUpAfterVariableInstanceTest(processInstanceId);
        }).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the historic variable instances of process instance '" + processInstanceId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteHistoricVariableInstancesWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        String processInstanceId = this.startProcessInstance(null);
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue");
        this.runtimeService.setVariable(processInstanceId, "myVariable", (Object)"testValue2");
        HistoricVariableInstanceQuery variableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId);
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(1L);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
        Assertions.assertThat((long)variableQuery.count()).isEqualTo(0L);
        this.cleanUpAfterVariableInstanceTest(processInstanceId);
    }

    @Test
    public void deleteHistoricVariableInstancesWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, BPMN_ONETASK_PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, BPMN_ONETASK_PROCESS);
        String processInstanceIdOne = this.startProcessInstance(TENANT_ONE);
        String processInstanceIdTwo = this.startProcessInstance(TENANT_TWO);
        this.runtimeService.setVariable(processInstanceIdOne, "myVariable", (Object)"testValue");
        this.runtimeService.setVariable(processInstanceIdOne, "mySecondVariable", (Object)"testValue2");
        this.runtimeService.setVariable(processInstanceIdTwo, "myVariable", (Object)"testValue");
        this.runtimeService.setVariable(processInstanceIdTwo, "mySecondVariable", (Object)"testValue2");
        HistoricVariableInstanceQuery variableQueryOne = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceIdOne);
        HistoricVariableInstanceQuery variableQueryTwo = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceIdTwo);
        Assertions.assertThat((long)variableQueryOne.count()).isEqualTo(2L);
        Assertions.assertThat((long)variableQueryTwo.count()).isEqualTo(2L);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(processInstanceIdOne);
        Assertions.assertThat((long)variableQueryOne.count()).isEqualTo(0L);
        Assertions.assertThat((long)variableQueryTwo.count()).isEqualTo(2L);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(processInstanceIdTwo);
        Assertions.assertThat((long)variableQueryTwo.count()).isEqualTo(0L);
        this.cleanUpAfterVariableInstanceTest(processInstanceIdOne, processInstanceIdTwo);
    }

    protected String startProcessInstance(String tenantId) {
        if (tenantId == null) {
            return this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        }
        return this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(tenantId).execute().getId();
    }

    protected String createAndCloseCaseInstance(String tenantId) {
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("oneTaskCase");
        String caseInstanceId = tenantId == null ? builder.create().getId() : builder.caseDefinitionTenantId(tenantId).create().getId();
        this.caseService.completeCaseExecution(caseInstanceId);
        this.caseService.closeCaseInstance(caseInstanceId);
        return caseInstanceId;
    }

    protected String evaluateDecisionTable(String tenantId) {
        String decisionDefinitionId = tenantId == null ? ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult()).getId() : ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{tenantId}).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze");
        this.decisionService.evaluateDecisionTableById(decisionDefinitionId, (Map)variables);
        return decisionDefinitionId;
    }

    protected String createTaskForTenant(String tenantId) {
        Task task = this.taskService.newTask();
        task.setTenantId(TENANT_ONE);
        this.taskService.saveTask(task);
        this.taskService.complete(task.getId());
        return task.getId();
    }

    protected void cleanUpAfterVariableInstanceTest(String ... processInstanceIds) {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        for (String processInstanceId : processInstanceIds) {
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            if (task != null) {
                this.taskService.complete(task.getId());
            }
            this.historyService.deleteHistoricProcessInstance(processInstanceId);
        }
        this.identityService.clearAuthentication();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
        this.processEngineConfiguration.setTenantCheckEnabled(true);
    }
}

