/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.OptimizeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.optimize.OptimizeHistoricIdentityLinkLogEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricIdentityLinkLogsForOptimizeTest {
    public static final String IDENTITY_LINK_ADD = "add";
    public static final String IDENTITY_LINK_DELETE = "delete";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected static final String userId = "testUser";
    protected static final String assignerId = "testAssigner";
    protected static final String groupId = "testGroup";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(userId);
        this.createGroup();
        this.identityService.setAuthenticatedUserId(userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
        this.identityService.clearAuthentication();
    }

    @Test
    public void allNecessaryInformationIsAvailable() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(assignerId);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatIdentityLinksHaveAllImportantInformation((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0), processInstance);
    }

    @Test
    public void performCandidateOperations() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(assignerId);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.addCandidateUser(taskId, userId);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.taskService.deleteCandidateUser(taskId, userId);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.taskService.addCandidateGroup(taskId, groupId);
        Date nowPlus6Seconds = new Date(now.getTime() + 6000L);
        ClockUtil.setCurrentTime((Date)nowPlus6Seconds);
        this.taskService.deleteCandidateGroup(taskId, groupId);
        Date nowPlus8Seconds = new Date(now.getTime() + 8000L);
        ClockUtil.setCurrentTime((Date)nowPlus8Seconds);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getUserId(), (Matcher)CoreMatchers.is((Object)userId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getType(), (Matcher)CoreMatchers.is((Object)"candidate"));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getUserId(), (Matcher)CoreMatchers.is((Object)userId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_DELETE));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getType(), (Matcher)CoreMatchers.is((Object)"candidate"));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(2)).getGroupId(), (Matcher)CoreMatchers.is((Object)groupId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(2)).getType(), (Matcher)CoreMatchers.is((Object)"candidate"));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(3)).getGroupId(), (Matcher)CoreMatchers.is((Object)groupId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(3)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_DELETE));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(3)).getType(), (Matcher)CoreMatchers.is((Object)"candidate"));
    }

    @Test
    public void performAssigneeOperations() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        this.identityService.setAuthenticatedUserId(assignerId);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.claimAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.unclaimAllUserTasks();
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getUserId(), (Matcher)CoreMatchers.is((Object)userId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getType(), (Matcher)CoreMatchers.is((Object)"assignee"));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getUserId(), (Matcher)CoreMatchers.is((Object)userId));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_DELETE));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getType(), (Matcher)CoreMatchers.is((Object)"assignee"));
    }

    @Test
    public void occurredAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").camundaAssignee(userId)).endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.addCandidateUser(taskId, userId);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.taskService.deleteCandidateUser(taskId, userId);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(now, null, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void occurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.addCandidateUser(taskId, userId);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.taskService.deleteCandidateUser(taskId, userId);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(null, now, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void occurredAfterAndOccurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.addCandidateUser(taskId, userId);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.taskService.deleteCandidateUser(taskId, userId);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(now, now, 10);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, userId);
        this.taskService.deleteCandidateUser(taskId, userId);
        this.taskService.addCandidateUser(taskId, userId);
        this.taskService.deleteCandidateUser(taskId, userId);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByTimestamp() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.taskService.addCandidateUser(taskId, userId);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.taskService.deleteCandidateUser(taskId, userId);
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.taskService.addCandidateUser(taskId, userId);
        List identityLinkLogs = this.optimizeService.getHistoricIdentityLinkLogs(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)identityLinkLogs.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_DELETE));
        MatcherAssert.assertThat((Object)((OptimizeHistoricIdentityLinkLogEntity)identityLinkLogs.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void claimAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), userId);
        }
    }

    private void unclaimAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.setAssignee(task.getId(), null);
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    protected void createGroup() {
        Group group = this.identityService.newGroup(groupId);
        this.identityService.saveGroup(group);
    }

    private void assertThatIdentityLinksHaveAllImportantInformation(OptimizeHistoricIdentityLinkLogEntity identityLinkLog, ProcessInstance processInstance) {
        MatcherAssert.assertThat((Object)identityLinkLog, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)identityLinkLog.getUserId(), (Matcher)CoreMatchers.is((Object)userId));
        MatcherAssert.assertThat((Object)identityLinkLog.getTaskId(), (Matcher)CoreMatchers.is((Object)((Task)this.taskService.createTaskQuery().singleResult()).getId()));
        MatcherAssert.assertThat((Object)identityLinkLog.getType(), (Matcher)CoreMatchers.is((Object)"candidate"));
        MatcherAssert.assertThat((Object)identityLinkLog.getAssignerId(), (Matcher)CoreMatchers.is((Object)assignerId));
        MatcherAssert.assertThat((Object)identityLinkLog.getGroupId(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)identityLinkLog.getOperationType(), (Matcher)CoreMatchers.is((Object)IDENTITY_LINK_ADD));
        MatcherAssert.assertThat((Object)identityLinkLog.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processInstance.getProcessDefinitionId()));
        MatcherAssert.assertThat((Object)identityLinkLog.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)identityLinkLog.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
    }
}

