/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.impl.OptimizeService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.FailingDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetOpenHistoricIncidentsForOptimizeTest {
    private static final String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";
    private static final BpmnModelInstance FAILING_SERVICE_TASK_MODEL = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"oneFailingServiceTaskProcess").startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent("end").done();
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    private RuntimeService runtimeService;
    private ManagementService managementService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void cleanUp() {
        ClockUtil.reset();
    }

    @Test
    public void getOpenHistoricIncidents() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatInstanceHasAllImportantInformation((HistoricIncidentEntity)openIncidents.get(0));
    }

    @Test
    public void fishedAfterParameterWorks() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.startProcessInstanceAndFailWithIncident();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance processInstance = this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(now, null, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
    }

    @Test
    public void fishedAtParameterWorks() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.startProcessInstanceAndFailWithIncident();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(null, now, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
    }

    @Test
    public void fishedAfterAndFinishedAtParameterWorks() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.startProcessInstanceAndFailWithIncident();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(now, now, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        for (int i = 0; i < 5; ++i) {
            this.startProcessInstanceAndFailWithIncident();
        }
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByEndTime() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        Date now = new Date();
        Date nowPlus1Second = new Date(now.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)nowPlus1Second);
        ProcessInstance processInstance1 = this.startProcessInstanceAndFailWithIncident();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance processInstance2 = this.startProcessInstanceAndFailWithIncident();
        Date nowPlus4Seconds = new Date(nowPlus2Seconds.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        ProcessInstance processInstance3 = this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(now, null, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance1.getId()));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance2.getId()));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance3.getId()));
    }

    @Test
    public void fetchOnlyOpenIncidents() {
        this.testHelper.deploy(FAILING_SERVICE_TASK_MODEL);
        ProcessInstance processInstanceWithCompletedIncident = this.startProcessInstanceAndFailWithIncident();
        this.retryAndSucceed(processInstanceWithCompletedIncident);
        ProcessInstance processInstanceWithOpenIncident = this.startProcessInstanceAndFailWithIncident();
        List openIncidents = this.optimizeService.getOpenHistoricIncidents(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)openIncidents.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricIncidentEntity)openIncidents.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstanceWithOpenIncident.getId()));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void assertThatInstanceHasAllImportantInformation(HistoricIncidentEntity historicIncidentEntity) {
        MatcherAssert.assertThat((Object)historicIncidentEntity, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicIncidentEntity.getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicIncidentEntity.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)PROCESS_DEFINITION_KEY));
        MatcherAssert.assertThat((Object)historicIncidentEntity.getProcessDefinitionVersion(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)historicIncidentEntity.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicIncidentEntity.getCreateTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicIncidentEntity.getEndTime(), (Matcher)CoreMatchers.nullValue());
    }

    private void retryAndSucceed(ProcessInstance processInstance) {
        this.runtimeService.setVariable(processInstance.getId(), "fail", (Object)false);
        String jobId = ((Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
    }

    private ProcessInstance startProcessInstanceAndFailWithIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        return processInstance;
    }
}

