/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.application.ProcessApplicationRegistration;
import org.eximeebpms.bpm.application.impl.EmbeddedProcessApplication;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.application.ProcessApplicationManager;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentHandlerFactory;
import org.eximeebpms.bpm.engine.repository.DeploymentQuery;
import org.eximeebpms.bpm.engine.repository.ProcessApplicationDeployment;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.bpmn.deployment.VersionedDeploymentHandlerFactory;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessApplicationDeploymentTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected ProcessEngine processEngine;
    private EmbeddedProcessApplication processApplication;
    protected DeploymentHandlerFactory defaultDeploymentHandlerFactory;
    protected DeploymentHandlerFactory customDeploymentHandlerFactory;
    protected ProcessApplicationManager processApplicationManager;
    protected DeploymentCache deploymentCache;
    Set<String> registeredDeployments;

    @Before
    public void setUp() throws Exception {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.defaultDeploymentHandlerFactory = this.processEngineConfiguration.getDeploymentHandlerFactory();
        this.customDeploymentHandlerFactory = new VersionedDeploymentHandlerFactory();
        this.processApplication = new EmbeddedProcessApplication();
        this.processApplicationManager = this.processEngineConfiguration.getProcessApplicationManager();
        this.deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        this.registeredDeployments = this.processEngineConfiguration.getRegisteredDeployments();
    }

    @After
    public void tearDown() throws Exception {
        this.clearProcessApplicationDeployments();
        this.processApplication.undeploy();
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.defaultDeploymentHandlerFactory);
        ClockUtil.reset();
    }

    @Test
    public void testEmptyDeployment() {
        try {
            this.repositoryService.createDeployment(this.processApplication.getReference()).deploy();
            Assert.fail((String)"it should not be possible to deploy without deployment resources");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            this.repositoryService.createDeployment().deploy();
            Assert.fail((String)"it should not be possible to deploy without deployment resources");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleProcessApplicationDeployment() {
        ProcessApplicationDeployment deployment = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentNoChanges() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testPartialChangesDeployAll() {
        BpmnModelInstance model1 = this.createEmptyModel("process1");
        BpmnModelInstance model2 = this.createEmptyModel("process2");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2));
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2));
        Assert.assertEquals((long)4L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        List processDefinitionsModel1 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)processDefinitionsModel1.size());
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitionsModel1.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitionsModel1.get(1)).getVersion());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)processDefinitionsModel2.size());
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)2L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testPartialChangesDeployChangedOnly() {
        BpmnModelInstance model1 = this.createEmptyModel("process1");
        BpmnModelInstance model2 = this.createEmptyModel("process2");
        ProcessApplicationDeployment deployment1 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2));
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2));
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinition processDefinitionModel1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
        Assert.assertNotNull((Object)processDefinitionModel1);
        Assert.assertEquals((long)1L, (long)processDefinitionModel1.getVersion());
        Assert.assertEquals((Object)deployment1.getId(), (Object)processDefinitionModel1.getDeploymentId());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)processDefinitionsModel2.size());
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)2L, (long)deploymentIds.size());
        BpmnModelInstance anotherChangedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        ProcessApplicationDeployment deployment3 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", anotherChangedModel2).name("deployment"));
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        registration = deployment3.getProcessApplicationRegistration();
        deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)3L, (long)deploymentIds.size());
    }

    @Test
    public void testDuplicateFilteringDefaultBehavior() {
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("3")).done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).done();
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).addModelInstance("model", oldModel).name("defaultDeploymentHandling"));
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).addModelInstance("model", newModel).name("defaultDeploymentHandling"));
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assert.assertEquals((long)2L, (long)deploymentCount);
    }

    @Test
    public void testDuplicateFilteringCustomBehavior() {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.customDeploymentHandlerFactory);
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).startEvent().done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("3")).startEvent().done();
        Object deployment1 = this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling"));
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).addModelInstance("model.bpmn", newModel).name("customDeploymentHandling"));
        Object deployment3 = this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling"));
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assert.assertEquals((long)2L, (long)deploymentCount);
        Assert.assertEquals((Object)deployment1.getId(), (Object)deployment3.getId());
    }

    @Test
    public void testPartialChangesResumePreviousVersion() {
        BpmnModelInstance model1 = this.createEmptyModel("process1");
        BpmnModelInstance model2 = this.createEmptyModel("process2");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1));
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2));
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Assert.assertEquals((long)2L, (long)registration.getDeploymentIds().size());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersions() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version2.bpmn20.xml"));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)2L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsDifferentKeys() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().addClasspathResource("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertEquals((Object)deployment2.getId(), deploymentIds.iterator().next());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsDefaultBehavior() {
        BpmnModelInstance model1 = this.createEmptyModel("process1");
        BpmnModelInstance model2 = this.createEmptyModel("process2");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("defaultDeploymentHandling").addModelInstance("process1.bpmn20.xml", model1));
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("defaultDeploymentHandling").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2));
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Assert.assertEquals((long)2L, (long)registration.getDeploymentIds().size());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsCustomBehavior() {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.customDeploymentHandlerFactory);
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaVersionTag("1")).startEvent().done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaVersionTag("3")).startEvent().done();
        ProcessApplicationDeployment deployment1 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("customDeploymentHandling").addModelInstance("process1.bpmn20.xml", oldModel));
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("customDeploymentHandling").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", newModel));
        ProcessApplicationDeployment deployment3 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("customDeploymentHandling").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", oldModel));
        ProcessApplicationRegistration registration2 = deployment2.getProcessApplicationRegistration();
        Assert.assertEquals((long)1L, (long)registration2.getDeploymentIds().size());
        ProcessApplicationRegistration registration3 = deployment3.getProcessApplicationRegistration();
        Assert.assertEquals((long)1L, (long)registration3.getDeploymentIds().size());
        Assert.assertEquals((Object)deployment1.getId(), registration3.getDeploymentIds().iterator().next());
    }

    @Test
    public void testProcessApplicationDeploymentNoResume() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version2.bpmn20.xml"));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameDefaultBehavior() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version2.bpmn20.xml"));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)2L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameCustomBehavior() {
        BpmnModelInstance oldProcess = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaVersionTag("1")).startEvent().done();
        BpmnModelInstance newProcess = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaVersionTag("2")).startEvent().done();
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.customDeploymentHandlerFactory);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("version1.bpmn20.xml", oldProcess));
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("version2.bpmn20.xml", newProcess));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set paDeploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)paDeploymentIds.size());
        Assert.assertTrue((boolean)paDeploymentIds.contains(deployment2.getId()));
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameDeployDifferentProcesses() {
        BpmnModelInstance process1 = this.createEmptyModel("process1");
        BpmnModelInstance process2 = this.createEmptyModel("process2");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process2));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)2L, (long)deploymentIds.size());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameNoResume() {
        BpmnModelInstance process1 = this.createEmptyModel("process1");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1));
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("anotherDeployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process1));
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)1L, (long)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        Assert.assertEquals((long)2L, (long)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        Assert.assertEquals((long)1L, (long)deploymentIds.size());
        Assert.assertEquals((Object)deployment2.getId(), deploymentIds.iterator().next());
        Assert.assertEquals((Object)this.processEngine.getName(), (Object)registration.getProcessEngineName());
    }

    @Test
    public void testPartialChangesResumePreviousVersionByDeploymentName() {
        BpmnModelInstance model1 = this.createEmptyModel("process1");
        BpmnModelInstance model2 = this.createEmptyModel("process2");
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1));
        ProcessApplicationDeployment deployment2 = (ProcessApplicationDeployment)this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2));
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Assert.assertEquals((long)2L, (long)registration.getDeploymentIds().size());
    }

    @Test
    public void testProcessApplicationDeploymentResumptionDoesNotCachePreviousBpmnModelInstance() {
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.deploymentCache.discardProcessDefinitionCache();
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version2.bpmn20.xml"));
        Assert.assertTrue((boolean)this.deploymentCache.getBpmnModelInstanceCache().isEmpty());
    }

    @Test
    public void testDeploymentSourceShouldBeNull() {
        String key = "process";
        BpmnModelInstance model = this.createEmptyModel(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        this.testRule.deploy(this.repositoryService.createDeployment().name("first-deployment-without-a-source").addModelInstance("process.bpmn", model));
        Assert.assertNull((Object)((Deployment)deploymentQuery.deploymentName("first-deployment-without-a-source").singleResult()).getSource());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("second-deployment-with-a-source").source(null).addModelInstance("process.bpmn", model));
        Assert.assertNull((Object)((Deployment)deploymentQuery.deploymentName("second-deployment-with-a-source").singleResult()).getSource());
    }

    @Test
    public void testDeploymentSourceShouldNotBeNull() {
        String key = "process";
        BpmnModelInstance model = this.createEmptyModel(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        this.testRule.deploy(this.repositoryService.createDeployment().name("first-deployment-without-a-source").source("my-first-deployment-source").addModelInstance("process.bpmn", model));
        Assert.assertEquals((Object)"my-first-deployment-source", (Object)((Deployment)deploymentQuery.deploymentName("first-deployment-without-a-source").singleResult()).getSource());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("second-deployment-with-a-source").source("my-second-deployment-source").addModelInstance("process.bpmn", model));
        Assert.assertEquals((Object)"my-second-deployment-source", (Object)((Deployment)deploymentQuery.deploymentName("second-deployment-with-a-source").singleResult()).getSource());
    }

    @Test
    public void testDefaultDeploymentSource() {
        String key = "process";
        BpmnModelInstance model = this.createEmptyModel(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("first-deployment-with-a-source").addModelInstance("process.bpmn", model));
        Assert.assertEquals((Object)"process application", (Object)((Deployment)deploymentQuery.deploymentName("first-deployment-with-a-source").singleResult()).getSource());
    }

    @Test
    public void testOverwriteDeploymentSource() {
        String key = "process";
        BpmnModelInstance model = this.createEmptyModel(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("first-deployment-with-a-source").source("my-source").addModelInstance("process.bpmn", model));
        Assert.assertEquals((Object)"my-source", (Object)((Deployment)deploymentQuery.deploymentName("first-deployment-with-a-source").singleResult()).getSource());
    }

    @Test
    public void testNullDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
    }

    @Test
    public void testNullAndProcessApplicationDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
    }

    @Test
    public void testProcessApplicationAndNullDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
    }

    @Test
    public void testProcessApplicationDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
    }

    @Test
    public void testSameDeploymentSourceAwareDuplicateFilter() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("cockpit").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("my-deployment").source("cockpit").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
    }

    @Test
    public void testDifferentDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source1").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source2").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)2L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)2L, (long)deploymentQuery.count());
    }

    @Test
    public void testNullAndNotNullDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source2").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)2L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)2L, (long)deploymentQuery.count());
    }

    @Test
    public void testNotNullAndNullDeploymentSourceShouldDeployNewVersion() {
        String key = "process";
        String name = "my-deployment";
        BpmnModelInstance model = this.createEmptyModel(key);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key);
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery().deploymentName(name);
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source("my-source1").addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)1L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name(name).source(null).addModelInstance("process.bpmn", model).enableDuplicateFiltering(true));
        Assert.assertEquals((long)2L, (long)processDefinitionQuery.count());
        Assert.assertEquals((long)2L, (long)deploymentQuery.count());
    }

    @Test
    public void testUnregisterProcessApplicationOnDeploymentDeletion() {
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process.bpmn", this.createEmptyModel("foo")));
        this.managementService.registerProcessApplication(deployment.getId(), this.processApplication.getReference());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        Assert.assertNull((Object)this.managementService.getProcessApplicationForDeployment(deployment.getId()));
    }

    @Test
    public void shouldRegisterExistingDeploymentsOnLatestProcessDefinitionRemoval() {
        Date timeFreeze = new Date();
        ClockUtil.setCurrentTime((Date)timeFreeze);
        BpmnModelInstance process1 = this.createEmptyModel("process");
        BpmnModelInstance process2 = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        Object deployment1 = this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("foo").addModelInstance("process.bpmn", process1));
        ClockUtil.offset((Long)1000L);
        Object deployment2 = this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).name("foo").addModelInstance("process.bpmn", process2).resumePreviousVersions().enableDuplicateFiltering(true));
        ProcessDefinition latestProcessDefinition = (ProcessDefinition)deployment2.getDeployedProcessDefinitions().get(0);
        Assume.assumeNotNull((Object[])new Object[]{this.managementService.getProcessApplicationForDeployment(deployment1.getId())});
        Assume.assumeNotNull((Object[])new Object[]{this.managementService.getProcessApplicationForDeployment(deployment2.getId())});
        this.repositoryService.deleteProcessDefinition(latestProcessDefinition.getId());
        this.clearProcessApplicationDeployments();
        this.testRule.deploy((DeploymentBuilder)this.repositoryService.createDeployment(this.processApplication.getReference()).addModelInstance("process.bpmn", process2).resumePreviousVersions().enableDuplicateFiltering(true).name("foo"));
        Assert.assertNotNull((Object)this.managementService.getProcessApplicationForDeployment(deployment1.getId()));
        Assert.assertNotNull((Object)this.managementService.getProcessApplicationForDeployment(deployment2.getId()));
    }

    protected void clearProcessApplicationDeployments() {
        this.processApplicationManager.clearRegistrations();
        this.registeredDeployments.clear();
        this.deploymentCache.discardProcessDefinitionCache();
    }

    protected void assertThatOneProcessIsDeployed() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((Object)processDefinition).isNotNull();
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
    }

    protected BpmnModelInstance createEmptyModel(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().done();
    }
}

