/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.repository.AbstractDefinitionQueryTest;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProcessDefinitionQueryTest
extends AbstractDefinitionQueryTest {
    private static final String THIRD_DEPLOYMENT_NAME = "thirdDeployment";
    private String deploymentThreeId;

    @Override
    protected String getResourceOnePath() {
        return "org/eximeebpms/bpm/engine/test/repository/one.bpmn20.xml";
    }

    @Override
    protected String getResourceTwoPath() {
        return "org/eximeebpms/bpm/engine/test/repository/two.bpmn20.xml";
    }

    protected String getResourceThreePath() {
        return "org/eximeebpms/bpm/engine/test/repository/three_.bpmn20.xml";
    }

    @Before
    public void setUp() throws Exception {
        this.deploymentThreeId = this.repositoryService.createDeployment().name(THIRD_DEPLOYMENT_NAME).addClasspathResource(this.getResourceThreePath()).deploy().getId();
    }

    @After
    public void tearDown() throws Exception {
        ClockUtil.reset();
        this.repositoryService.deleteDeployment(this.deploymentThreeId, true);
    }

    @Test
    public void testProcessDefinitionProperties() {
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).orderByProcessDefinitionCategory().asc()).list();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Assertions.assertThat((String)processDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)processDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)processDefinition.getDescription()).isEqualTo((Object)"Desc one");
        Assertions.assertThat((String)processDefinition.getId()).startsWith((CharSequence)"one:1");
        Assertions.assertThat((String)processDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((boolean)processDefinition.isStartableInTasklist()).isEqualTo(true);
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        Assertions.assertThat((String)processDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)processDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)processDefinition.getDescription()).isEqualTo((Object)"Desc one");
        Assertions.assertThat((String)processDefinition.getId()).startsWith((CharSequence)"one:2");
        Assertions.assertThat((String)processDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((boolean)processDefinition.isStartableInTasklist()).isEqualTo(true);
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        Assertions.assertThat((String)processDefinition.getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((String)processDefinition.getName()).isEqualTo((Object)"Two");
        Assertions.assertThat((String)processDefinition.getDescription()).isNull();
        Assertions.assertThat((boolean)processDefinition.getId().startsWith("two:1"));
        Assertions.assertThat((String)processDefinition.getCategory()).isEqualTo((Object)"Examples2");
        Assertions.assertThat((boolean)processDefinition.isStartableInTasklist()).isEqualTo(true);
        processDefinition = (ProcessDefinition)processDefinitions.get(3);
        Assertions.assertThat((String)processDefinition.getKey()).isEqualTo((Object)"xyz_");
        Assertions.assertThat((String)processDefinition.getName()).isEqualTo((Object)"Xyz_");
        Assertions.assertThat((String)processDefinition.getDescription()).isNull();
        Assertions.assertThat((boolean)processDefinition.getId().startsWith("xyz_:1"));
        Assertions.assertThat((String)processDefinition.getCategory()).isEqualTo((Object)"xyz_");
        Assertions.assertThat((boolean)processDefinition.isStartableInTasklist()).isEqualTo(false);
    }

    @Test
    public void testQueryByDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId(this.deploymentOneId);
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().deploymentId(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByDeploymentTimeAfter() {
        Date startTest = DateUtils.addSeconds((Date)ClockUtil.now(), (int)5);
        ClockUtil.setCurrentTime((Date)startTest);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)startTest, (int)5));
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentOne = this.repositoryService.createDeployment().addClasspathResource(this.getResourceOnePath()).addClasspathResource(this.getResourceTwoPath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentOne);
        Date timeAfterDeploymentOne = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)timeAfterDeploymentOne, (int)5));
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentTwo = this.repositoryService.createDeployment().addClasspathResource(this.getResourceOnePath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentTwo);
        Date timeAfterDeploymentTwo = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        ClockUtil.setCurrentTime((Date)DateUtils.addSeconds((Date)timeAfterDeploymentTwo, (int)5));
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentThree = this.repositoryService.createDeployment().addClasspathResource(this.getResourceThreePath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentThree);
        Date timeAfterDeploymentThree = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)1);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAfter(startTest).list();
        Assertions.assertThat((List)processDefinitions).hasSize(4);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAfter(timeAfterDeploymentOne).list();
        Assertions.assertThat((List)processDefinitions).hasSize(2);
        this.assertThatProcessDefinitionsWereDeployedAfter(processDefinitions, timeAfterDeploymentOne);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAfter(timeAfterDeploymentTwo).list();
        Assertions.assertThat((List)processDefinitions).hasSize(1);
        this.assertThatProcessDefinitionsWereDeployedAfter(processDefinitions, timeAfterDeploymentTwo);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAfter(timeAfterDeploymentThree).list();
        Assertions.assertThat((List)processDefinitions).hasSize(0);
    }

    @Test
    public void testQueryByDeploymentTimeAt() throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");
        Date startTest = formatter.parse(formatter.format(DateUtils.addSeconds((Date)ClockUtil.now(), (int)5)));
        ClockUtil.setCurrentTime((Date)startTest);
        Date timeAtDeploymentOne = ClockUtil.getCurrentTime();
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentOne = this.repositoryService.createDeployment().addClasspathResource(this.getResourceOnePath()).addClasspathResource(this.getResourceTwoPath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentOne);
        Date timeAtDeploymentTwo = DateUtils.addSeconds((Date)timeAtDeploymentOne, (int)5);
        ClockUtil.setCurrentTime((Date)timeAtDeploymentTwo);
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentTwo = this.repositoryService.createDeployment().addClasspathResource(this.getResourceOnePath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentTwo);
        Date timeAtDeploymentThree = DateUtils.addSeconds((Date)timeAtDeploymentTwo, (int)5);
        ClockUtil.setCurrentTime((Date)timeAtDeploymentThree);
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentThree = this.repositoryService.createDeployment().addClasspathResource(this.getResourceThreePath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentThree);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAt(timeAtDeploymentOne).list();
        Assertions.assertThat((List)processDefinitions).hasSize(2);
        this.assertThatProcessDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentOne);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAt(timeAtDeploymentTwo).list();
        Assertions.assertThat((List)processDefinitions).hasSize(1);
        this.assertThatProcessDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentTwo);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAt(timeAtDeploymentThree).list();
        Assertions.assertThat((List)processDefinitions).hasSize(1);
        this.assertThatProcessDefinitionsWereDeployedAt(processDefinitions, timeAtDeploymentThree);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().deployedAt(DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)5)).list();
        Assertions.assertThat((List)processDefinitions).hasSize(0);
    }

    @Test
    public void testQueryByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("Two");
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("One");
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByInvalidName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionName(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%w%");
        this.verifyQueryResults((Query)query, 1);
        query = query.processDefinitionNameLike("%z\\_%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
    }

    @Test
    public void testQueryByNameLikeCaseInsensitive() {
        ProcessDefinitionQuery queryCaseInsensitive = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%OnE%");
        this.verifyQueryResults((Query)queryCaseInsensitive, 2);
    }

    @Test
    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one");
        this.verifyQueryResults((Query)query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByKeys() {
        Assertions.assertThat((List)this.repositoryService.createProcessDefinitionQuery().processDefinitionKeysIn(new String[]{"a", "b"}).list()).isEmpty();
        List list = this.repositoryService.createProcessDefinitionQuery().list();
        String[] processDefinitionKeys = new String[list.size()];
        for (int i = 0; i < processDefinitionKeys.length; ++i) {
            processDefinitionKeys[i] = ((ProcessDefinition)list.get(i)).getKey();
        }
        List keyInList = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeysIn(processDefinitionKeys).list();
        for (ProcessDefinition processDefinition : keyInList) {
            boolean found = false;
            for (ProcessDefinition otherProcessDefinition : list) {
                if (!otherProcessDefinition.getKey().equals(processDefinition.getKey())) continue;
                found = true;
                break;
            }
            Assertions.assertThat((boolean)found).withFailMessage("Expected to find process definition " + processDefinition, new Object[0]);
        }
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("dummyKey").processDefinitionKeysIn(processDefinitionKeys).count()).isEqualTo(0L);
    }

    @Test
    public void testQueryByInvalidKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%o%");
        this.verifyQueryResults((Query)query, 3);
        query = query.processDefinitionKeyLike("%z\\_%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByResourceNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceNameLike("%ee\\_%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidResourceNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceNameLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceNameLike(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByCategory() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategory("Examples");
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByCategoryLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%Example%");
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%amples2");
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%z\\_%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults((Query)query, 3);
    }

    @Test
    public void testQueryByInvalidVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(-1)).list()).isInstanceOf(ProcessEngineException.class);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(null).list()).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByKeyAndVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults((Query)query, 0);
    }

    @Test
    public void testQueryByLatest() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().latestVersion();
        this.verifyQueryResults((Query)query, 3);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two").latestVersion();
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testInvalidUsageOfLatest() {
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionId("test").latestVersion().list()).isInstanceOf(ProcessEngineException.class);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).latestVersion().list()).isInstanceOf(ProcessEngineException.class);
        Assertions.assertThatThrownBy(() -> this.repositoryService.createProcessDefinitionQuery().deploymentId("test").latestVersion().list()).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQuerySorting() {
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().asc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().asc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().desc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().desc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().desc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc();
        this.verifyQueryResults((Query)query, 4);
        query = (ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc();
        List processDefinitions = query.list();
        Assertions.assertThat((int)processDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(0)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(0)).getVersion()).isEqualTo(2);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(1)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(1)).getVersion()).isEqualTo(1);
        Assertions.assertThat((String)((ProcessDefinition)processDefinitions.get(2)).getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((int)((ProcessDefinition)processDefinitions.get(2)).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByMessageSubscription() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processWithNewBookingMessage.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processWithNewInvoiceMessage.bpmn20.xml").deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newInvoiceMessage").count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newBookingMessage").count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("bogus").count()).isEqualTo(0L);
        this.repositoryService.deleteDeployment(deployment.getId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentId() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count()).isEqualTo(1L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.waitForJobExecutorToProcessAllJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assertions.assertThat((int)incidentList.size()).isEqualTo(1);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentId(incident.getId());
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidIncidentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query)query.incidentId("invalid"), 0);
        Assertions.assertThatThrownBy(() -> query.incidentId(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentType() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count()).isEqualTo(1L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.waitForJobExecutorToProcessAllJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assertions.assertThat((List)incidentList).hasSize(1);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentType(incident.getIncidentType());
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidIncidentType() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query)query.incidentType("invalid"), 0);
        Assertions.assertThatThrownBy(() -> query.incidentType(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count()).isEqualTo(1L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.waitForJobExecutorToProcessAllJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assertions.assertThat((int)incidentList.size()).isEqualTo(1);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentMessage(incident.getIncidentMessage());
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidIncidentMessage() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query)query.incidentMessage("invalid"), 0);
        Assertions.assertThatThrownBy(() -> query.incidentMessage(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count()).isEqualTo(1L);
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.waitForJobExecutorToProcessAllJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assertions.assertThat((List)incidentList).hasSize(1);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentMessageLike("%expected%");
        this.verifyQueryResults((Query)query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().incidentMessageLike("%\\_expected%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidIncidentMessageLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query)query.incidentMessageLike("invalid"), 0);
        Assertions.assertThatThrownBy(() -> query.incidentMessageLike(null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByProcessDefinitionIds() {
        Assertions.assertThat((List)this.repositoryService.createProcessDefinitionQuery().processDefinitionIdIn(new String[]{"a", "b"}).list()).isEmpty();
        List list = this.repositoryService.createProcessDefinitionQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((ProcessDefinition)list.get(i)).getId();
        }
        List idInList = this.repositoryService.createProcessDefinitionQuery().processDefinitionIdIn(ids).list();
        for (ProcessDefinition processDefinition : idInList) {
            boolean found = false;
            for (ProcessDefinition otherProcessDefinition : list) {
                if (!otherProcessDefinition.getId().equals(processDefinition.getId())) continue;
                found = true;
                break;
            }
            Assertions.assertThat((boolean)found).withFailMessage("Expected to find process definition " + processDefinition, new Object[0]);
        }
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionId("dummyId").processDefinitionIdIn(ids).count()).isEqualTo(0L);
    }

    @Test
    public void testQueryByLatestAndName() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionName("First Test Process").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        ProcessDefinition result = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"First Test Process");
        Assertions.assertThat((int)result.getVersion()).isEqualTo(2);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    @Test
    public void testQueryByLatestAndName_NotFound() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionName("First Test Process").latestVersion();
        this.verifyQueryResults((Query)query, 0);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    @Test
    public void testQueryByLatestAndNameLike() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionNameLike("%Test Process").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        ProcessDefinition result = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Second Test Process");
        Assertions.assertThat((int)result.getVersion()).isEqualTo(2);
        query.processDefinitionNameLike("%Test%").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        result = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Second Test Process");
        Assertions.assertThat((int)result.getVersion()).isEqualTo(2);
        query.processDefinitionNameLike("Second%").latestVersion();
        result = (ProcessDefinition)query.singleResult();
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Second Test Process");
        Assertions.assertThat((int)result.getVersion()).isEqualTo(2);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    @Test
    public void testQueryByLatestAndNameLike_NotFound() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionNameLike("First%").latestVersion();
        this.verifyQueryResults((Query)query, 0);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByVersionTag() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().versionTag("ver_tag_2").count()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByVersionTagLike() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().versionTagLike("ver\\_tag\\_%").count()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByNoVersionTag() {
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().withoutVersionTag().count()).isEqualTo(4L);
    }

    @Test
    public void testQueryOrderByDeployTime() {
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(10L));
        org.eximeebpms.bpm.engine.repository.Deployment tempDeploymentOne = this.repositoryService.createDeployment().addClasspathResource(this.getResourceOnePath()).addClasspathResource(this.getResourceOnePath()).deploy();
        this.engineRule.manageDeployment(tempDeploymentOne);
        ProcessDefinitionQuery processDefinitionOrderByDeploymentTimeAscQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentTime().asc();
        ProcessDefinitionQuery processDefinitionOrderByDeploymentTimeDescQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentTime().desc();
        TestOrderingUtil.verifySortingAndCount(processDefinitionOrderByDeploymentTimeAscQuery, 5, TestOrderingUtil.processDefinitionByDeployTime(this.engineRule.getProcessEngine()));
        TestOrderingUtil.verifySortingAndCount(processDefinitionOrderByDeploymentTimeDescQuery, 5, TestOrderingUtil.inverted(TestOrderingUtil.processDefinitionByDeployTime(this.engineRule.getProcessEngine())));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/repository/VersionTagTest.testParsingVersionTag.bpmn20.xml"})
    public void testQueryOrderByVersionTag() {
        List processDefinitionList = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().versionTagLike("ver%tag%").orderByVersionTag().asc()).list();
        Assertions.assertThat((String)((ProcessDefinition)processDefinitionList.get(1)).getVersionTag()).isEqualTo((Object)"ver_tag_2");
    }

    @Test
    public void testQueryByStartableInTasklist() {
        List startable = this.repositoryService.createProcessDefinitionQuery().startableInTasklist().list();
        List notStartable = this.repositoryService.createProcessDefinitionQuery().notStartableInTasklist().list();
        Assertions.assertThat((List)startable).hasSize(3);
        Assertions.assertThat((List)startable).extracting("key").containsExactlyInAnyOrder(new Object[]{"one", "one", "two"});
        Assertions.assertThat((List)notStartable).hasSize(1);
        Assertions.assertThat((String)((ProcessDefinition)notStartable.get(0)).getKey()).isEqualTo((Object)"xyz_");
    }

    @Test
    public void testQueryByStartableInTasklistNestedProcess() {
        BpmnModelInstance[] nestedProcess = this.setupNestedProcess(false);
        String deploymentId = this.testRule.deploy(nestedProcess).getId();
        ProcessDefinition actualStartable = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).startableInTasklist().singleResult();
        ProcessDefinition actualNotStartable = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).notStartableInTasklist().singleResult();
        Assertions.assertThat((String)actualStartable.getKey()).isEqualTo((Object)"calling");
        Assertions.assertThat((String)actualNotStartable.getKey()).isEqualTo((Object)"called");
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @Test
    public void testQueryByStartableInTasklistNestedProcessDeployedSecondTime() {
        BpmnModelInstance[] nestedProcess = this.setupNestedProcess(true);
        String deploymentId1 = this.testRule.deploy(nestedProcess).getId();
        long processes = this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId1).notStartableInTasklist().count();
        Assertions.assertThat((long)processes).isEqualTo(0L);
        nestedProcess = this.setupNestedProcess(false);
        String deploymentId2 = this.testRule.deploy(nestedProcess).getId();
        ProcessDefinition startable = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId2).startableInTasklist().singleResult();
        ProcessDefinition notStartable = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId2).notStartableInTasklist().singleResult();
        Assertions.assertThat((String)startable.getKey()).isEqualTo((Object)"calling");
        Assertions.assertThat((String)notStartable.getKey()).isEqualTo((Object)"called");
        this.repositoryService.deleteDeployment(deploymentId1);
        this.repositoryService.deleteDeployment(deploymentId2);
    }

    protected BpmnModelInstance[] setupNestedProcess(boolean isStartableSubprocess) {
        BpmnModelInstance[] result = new BpmnModelInstance[]{((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calling").startEvent().callActivity().calledElement("called")).endEvent().done(), ((ProcessBuilder)Bpmn.createExecutableProcess((String)"called").camundaStartableInTasklist(Boolean.valueOf(isStartableSubprocess))).startEvent().userTask().endEvent().done()};
        return result;
    }

    protected void assertThatProcessDefinitionsWereDeployedAfter(List<ProcessDefinition> processDefinitions, Date deployedAfter) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            Assertions.assertThat((Date)((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult()).getDeploymentTime()).isAfter(deployedAfter);
        }
    }

    protected void assertThatProcessDefinitionsWereDeployedAt(List<ProcessDefinition> processDefinitions, Date deployedAt) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            Assertions.assertThat((Date)((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult()).getDeploymentTime()).isEqualTo((Object)deployedAt);
        }
    }

    protected void cleanupDeployments(String ... deploymentId) {
        for (String id : deploymentId) {
            this.repositoryService.deleteDeployment(id, true);
        }
    }
}

