/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository.diagram;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.repository.DiagramLayout;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessDiagramParseTest {
    private static final String resourcePath = "src/test/resources/org/eximeebpms/bpm/engine/test/api/repository/diagram/testXxeParsingIsDisabled";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    boolean xxeProcessingValue;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.xxeProcessingValue = this.processEngineConfiguration.isEnableXxeProcessing();
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setEnableXxeProcessing(this.xxeProcessingValue);
    }

    @Test
    public void testXxeParsingIsDisabled() {
        this.processEngineConfiguration.setEnableXxeProcessing(false);
        try {
            final FileInputStream bpmnXmlStream = new FileInputStream("src/test/resources/org/eximeebpms/bpm/engine/test/api/repository/diagram/testXxeParsingIsDisabled.bpmn20.xml");
            final FileInputStream imageStream = new FileInputStream("src/test/resources/org/eximeebpms/bpm/engine/test/api/repository/diagram/testXxeParsingIsDisabled.png");
            Assert.assertNotNull((Object)bpmnXmlStream);
            this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<DiagramLayout>(){

                public DiagramLayout execute(CommandContext commandContext) {
                    return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(bpmnXmlStream, imageStream);
                }
            });
            Assert.fail((String)"The test model contains a DOCTYPE declaration! The test should fail.");
        }
        catch (FileNotFoundException ex) {
            Assert.fail((String)("The test BPMN model file is missing. " + ex.getMessage()));
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Error while parsing BPMN model"});
            Assertions.assertThat((String)e.getCause().getMessage()).contains(new CharSequence[]{"http://apache.org/xml/features/disallow-doctype-decl"});
        }
    }

    @Test
    public void testXxeParsingIsEnabled() {
        this.processEngineConfiguration.setEnableXxeProcessing(true);
        try {
            final FileInputStream bpmnXmlStream = new FileInputStream("src/test/resources/org/eximeebpms/bpm/engine/test/api/repository/diagram/testXxeParsingIsDisabled.bpmn20.xml");
            final FileInputStream imageStream = new FileInputStream("src/test/resources/org/eximeebpms/bpm/engine/test/api/repository/diagram/testXxeParsingIsDisabled.png");
            Assert.assertNotNull((Object)bpmnXmlStream);
            this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<DiagramLayout>(){

                public DiagramLayout execute(CommandContext commandContext) {
                    return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(bpmnXmlStream, imageStream);
                }
            });
            Assert.fail((String)"The test model contains a DOCTYPE declaration! The test should fail.");
        }
        catch (FileNotFoundException ex) {
            Assert.fail((String)("The test BPMN model file is missing. " + ex.getMessage()));
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Error while parsing BPMN model"});
            Assertions.assertThat((String)e.getCause().getMessage()).contains(new CharSequence[]{"file.txt"});
        }
    }
}

