/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Collection;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateAndResolveIncidentAuthorizationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void createIncident() {
        this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ExecutionEntity execution = (ExecutionEntity)this.engineRule.getRuntimeService().createExecutionQuery().active().singleResult();
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance", processInstance.getId()).bindResource("processDefinition", "Process").start();
        this.engineRule.getRuntimeService().createIncident("foo", execution.getId(), execution.getActivityId(), "bar");
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void resolveIncident() {
        this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ExecutionEntity execution = (ExecutionEntity)this.engineRule.getRuntimeService().createExecutionQuery().active().singleResult();
        this.authRule.disableAuthorization();
        Incident incident = this.engineRule.getRuntimeService().createIncident("foo", execution.getId(), execution.getActivityId(), "bar");
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance", processInstance.getId()).bindResource("processDefinition", "Process").start();
        this.engineRule.getRuntimeService().resolveIncident(incident.getId());
        this.authRule.assertScenario(this.scenario);
    }
}

