/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ExternalTaskService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.externaltask.LockedExternalTask;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.incident.IncidentContext;
import org.eximeebpms.bpm.engine.impl.incident.IncidentHandler;
import org.eximeebpms.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CreateAndResolveIncidentTest {
    public static final BpmnModelInstance ASYNC_TASK_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaExpression("${true}")).endEvent("end").done();
    public static final BpmnModelInstance EXTERNAL_TASK_PROCESS = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("task").camundaExternalTask("topic")).endEvent("end").done();
    private static final CustomIncidentHandler CUSTOM_HANDLER = new CustomIncidentHandler("custom");
    private static final CustomIncidentHandler JOB_HANDLER = new CustomIncidentHandler("failedJob");
    private static final CustomIncidentHandler EXTERNAL_TASK_HANDLER = new CustomIncidentHandler("failedExternalTask");
    private static final List<IncidentHandler> HANDLERS = new ArrayList<IncidentHandler>();
    @ClassRule
    public static ProcessEngineBootstrapRule processEngineBootstrapRule;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(processEngineBootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private ExternalTaskService externalTaskService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void resetHandlers() {
        HANDLERS.forEach(h -> ((CustomIncidentHandler)h).reset());
    }

    @Test
    public void createIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "aa", "bar");
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)incident2.getId(), (Object)incident.getId());
        Assert.assertEquals((Object)"foo", (Object)incident2.getIncidentType());
        Assert.assertEquals((Object)"aa", (Object)incident2.getConfiguration());
        Assert.assertEquals((Object)"bar", (Object)incident2.getIncidentMessage());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident2.getExecutionId());
    }

    @Test
    public void createIncidentWithNullExecution() {
        try {
            this.runtimeService.createIncident("foo", null, "userTask1", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Execution id cannot be null"});
        }
    }

    @Test
    public void createIncidentWithNullIncidentType() {
        try {
            this.runtimeService.createIncident(null, "processInstanceId", "foo", "bar");
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"incidentType is null"});
        }
    }

    @Test
    public void createIncidentWithNonExistingExecution() {
        try {
            this.runtimeService.createIncident("foo", "aaa", "bbb", "bar");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot find an execution with executionId 'aaa'"});
        }
    }

    @Test
    public void resolveIncident() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        this.runtimeService.resolveIncident(incident.getId());
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().executionId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)incident2);
    }

    @Test
    public void resolveUnexistingIncident() {
        try {
            this.runtimeService.resolveIncident("foo");
            Assert.fail((String)"Exception expected");
        }
        catch (NotFoundException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot find an incident with id 'foo'"});
        }
    }

    @Test
    public void resolveNullIncident() {
        try {
            this.runtimeService.resolveIncident(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"incidentId is null"});
        }
    }

    @Test
    public void resolveIncidentOfTypeFailedJob() {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        List jobs = this.engineRule.getManagementService().createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            this.engineRule.getManagementService().setJobRetries(job.getId(), 1);
            try {
                this.engineRule.getManagementService().executeJob(job.getId());
            }
            catch (Exception exception) {}
        }
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        try {
            this.runtimeService.resolveIncident(incident.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot resolve an incident of type failedJob"});
        }
    }

    @Test
    public void createIncidentWithIncidentHandler() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("custom", processInstance.getId(), "configuration");
        Assert.assertNotNull((Object)incident);
        Incident incident2 = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident2);
        Assert.assertEquals((Object)incident, (Object)incident2);
        Assert.assertEquals((Object)"custom", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)"configuration", (Object)incident.getConfiguration());
        Assertions.assertThat(CUSTOM_HANDLER.getCreateEvents()).hasSize(1);
        Assertions.assertThat(CUSTOM_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(CUSTOM_HANDLER.getDeleteEvents()).isEmpty();
    }

    @Test
    public void resolveIncidentWithIncidentHandler() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.createIncident("custom", processInstance.getId(), "configuration");
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.runtimeService.resolveIncident(incident.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNull((Object)incident);
        Assertions.assertThat(CUSTOM_HANDLER.getCreateEvents()).hasSize(1);
        Assertions.assertThat(CUSTOM_HANDLER.getResolveEvents()).hasSize(1);
        Assertions.assertThat(CUSTOM_HANDLER.getDeleteEvents()).isEmpty();
    }

    @Test
    public void shouldCallDeleteForCustomHandlerOnProcessInstanceCancellation() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.createIncident("custom", processInstance.getId(), "configuration");
        CUSTOM_HANDLER.reset();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assertions.assertThat(CUSTOM_HANDLER.getCreateEvents()).isEmpty();
        Assertions.assertThat(CUSTOM_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(CUSTOM_HANDLER.getDeleteEvents()).hasSize(1);
        IncidentContext deleteContext = CUSTOM_HANDLER.getDeleteEvents().get(0);
        Assertions.assertThat((String)deleteContext.getConfiguration()).isEqualTo((Object)"configuration");
        long numIncidents = this.runtimeService.createIncidentQuery().count();
        Assertions.assertThat((long)numIncidents).isEqualTo(0L);
    }

    @Test
    public void shouldCallDeleteForJobHandlerOnProcessInstanceCancellation() {
        this.testRule.deploy(ASYNC_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        JOB_HANDLER.reset();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assertions.assertThat(JOB_HANDLER.getCreateEvents()).isEmpty();
        Assertions.assertThat(JOB_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(JOB_HANDLER.getDeleteEvents()).hasSize(1);
        IncidentContext deleteContext = JOB_HANDLER.getDeleteEvents().get(0);
        Assertions.assertThat((String)deleteContext.getConfiguration()).isEqualTo((Object)job.getId());
        long numIncidents = this.runtimeService.createIncidentQuery().count();
        Assertions.assertThat((long)numIncidents).isEqualTo(0L);
    }

    @Test
    public void shouldCallDeleteForExternalTasksHandlerOnProcessInstanceCancellation() {
        this.testRule.deploy(EXTERNAL_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.externalTaskService.fetchAndLock(1, "foo").topic("topic", 1000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.setRetries(task.getId(), 0);
        EXTERNAL_TASK_HANDLER.reset();
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getCreateEvents()).isEmpty();
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getResolveEvents()).isEmpty();
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getDeleteEvents()).hasSize(1);
        IncidentContext deleteContext = EXTERNAL_TASK_HANDLER.getDeleteEvents().get(0);
        Assertions.assertThat((String)deleteContext.getConfiguration()).isEqualTo((Object)task.getId());
        long numIncidents = this.runtimeService.createIncidentQuery().count();
        Assertions.assertThat((long)numIncidents).isEqualTo(0L);
    }

    @Test
    public void shouldCallResolveForJobHandler() {
        this.testRule.deploy(ASYNC_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        JOB_HANDLER.reset();
        this.managementService.setJobRetries(job.getId(), 1);
        Assertions.assertThat(JOB_HANDLER.getCreateEvents()).isEmpty();
        Assertions.assertThat(JOB_HANDLER.getResolveEvents()).hasSize(1);
        Assertions.assertThat(JOB_HANDLER.getDeleteEvents()).isEmpty();
        IncidentContext deleteContext = JOB_HANDLER.getResolveEvents().get(0);
        Assertions.assertThat((String)deleteContext.getConfiguration()).isEqualTo((Object)job.getId());
        long numIncidents = this.runtimeService.createIncidentQuery().count();
        Assertions.assertThat((long)numIncidents).isEqualTo(0L);
    }

    @Test
    public void shouldCallResolveForExternalTaskHandler() {
        this.testRule.deploy(EXTERNAL_TASK_PROCESS);
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.externalTaskService.fetchAndLock(1, "foo").topic("topic", 1000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.setRetries(task.getId(), 0);
        EXTERNAL_TASK_HANDLER.reset();
        this.externalTaskService.setRetries(task.getId(), 1);
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getCreateEvents()).isEmpty();
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getResolveEvents()).hasSize(1);
        Assertions.assertThat(EXTERNAL_TASK_HANDLER.getDeleteEvents()).isEmpty();
        IncidentContext resolveContext = EXTERNAL_TASK_HANDLER.getResolveEvents().get(0);
        Assertions.assertThat((String)resolveContext.getConfiguration()).isEqualTo((Object)task.getId());
        long numIncidents = this.runtimeService.createIncidentQuery().count();
        Assertions.assertThat((long)numIncidents).isEqualTo(0L);
    }

    static {
        HANDLERS.add(CUSTOM_HANDLER);
        HANDLERS.add(JOB_HANDLER);
        HANDLERS.add(EXTERNAL_TASK_HANDLER);
        processEngineBootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setCustomIncidentHandlers(HANDLERS));
    }

    public static class CustomIncidentHandler
    implements IncidentHandler {
        private String incidentType;
        private List<IncidentContext> createEvents = new ArrayList<IncidentContext>();
        private List<IncidentContext> resolveEvents = new ArrayList<IncidentContext>();
        private List<IncidentContext> deleteEvents = new ArrayList<IncidentContext>();

        public CustomIncidentHandler(String type) {
            this.incidentType = type;
        }

        public String getIncidentHandlerType() {
            return this.incidentType;
        }

        public Incident handleIncident(IncidentContext context, String message) {
            this.createEvents.add(context);
            return IncidentEntity.createAndInsertIncident((String)this.incidentType, (IncidentContext)context, (String)message);
        }

        public void resolveIncident(IncidentContext context) {
            this.resolveEvents.add(context);
            this.deleteIncidentEntity(context);
        }

        public void deleteIncident(IncidentContext context) {
            this.deleteEvents.add(context);
            this.deleteIncidentEntity(context);
        }

        private void deleteIncidentEntity(IncidentContext context) {
            List incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(context.getConfiguration(), this.incidentType);
            incidents.forEach(i -> ((IncidentEntity)i).delete());
        }

        public List<IncidentContext> getCreateEvents() {
            return this.createEvents;
        }

        public List<IncidentContext> getResolveEvents() {
            return this.resolveEvents;
        }

        public List<IncidentContext> getDeleteEvents() {
            return this.deleteEvents;
        }

        public void reset() {
            this.createEvents.clear();
            this.resolveEvents.clear();
            this.deleteEvents.clear();
        }
    }
}

