/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.MismatchingMessageCorrelationException;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.MessageCorrelationResult;
import org.eximeebpms.bpm.engine.runtime.MessageCorrelationResultType;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ReceiveTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MessageCorrelationByLocalVariablesTest {
    public static final String TEST_MESSAGE_NAME = "TEST_MSG";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);

    @Test
    public void testReceiveTaskMessageCorrelation() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().receiveTask("MessageReceiver_1").message(TEST_MESSAGE_NAME)).camundaInputParameter("localVar", "${loopVar}")).camundaInputParameter("constVar", "someValue")).userTask("UserTask_1").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        this.testHelper.deploy(model);
        HashMap<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
        variables.put("vars", Arrays.asList(1, 2, 3));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        HashMap<String, Object> correlationKeys = new HashMap<String, Object>();
        int correlationKey = 1;
        correlationKeys.put("localVar", correlationKey);
        correlationKeys.put("constVar", "someValue");
        MessageCorrelationResult messageCorrelationResult = this.engineRule.getRuntimeService().createMessageCorrelation(messageName).localVariablesEqual(correlationKeys).setVariables((Map)Variables.createVariables().putValue("newVar", (Object)"newValue")).correlateWithResult();
        this.checkExecutionMessageCorrelationResult(messageCorrelationResult, processInstance, "MessageReceiver_1");
        List uncorrelatedExecutions = this.engineRule.getRuntimeService().createExecutionQuery().activityId("MessageReceiver_1").list();
        Assert.assertEquals((long)2L, (long)uncorrelatedExecutions.size());
    }

    @Test
    public void testIntermediateCatchEventMessageCorrelation() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().intermediateCatchEvent("MessageReceiver_1").message(TEST_MESSAGE_NAME)).camundaInputParameter("localVar", "${loopVar}")).userTask("UserTask_1").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        this.testHelper.deploy(model);
        HashMap<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
        variables.put("vars", Arrays.asList(1, 2, 3));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        int correlationKey = 1;
        MessageCorrelationResult messageCorrelationResult = this.engineRule.getRuntimeService().createMessageCorrelation(messageName).localVariableEquals("localVar", (Object)correlationKey).setVariables((Map)Variables.createVariables().putValue("newVar", (Object)"newValue")).correlateWithResult();
        this.checkExecutionMessageCorrelationResult(messageCorrelationResult, processInstance, "MessageReceiver_1");
        List uncorrelatedExecutions = this.engineRule.getRuntimeService().createExecutionQuery().activityId("MessageReceiver_1").list();
        Assert.assertEquals((long)2L, (long)uncorrelatedExecutions.size());
    }

    @Test
    public void testMessageBoundaryEventMessageCorrelation() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((BoundaryEventBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().userTask("UserTask_1").camundaInputParameter("localVar", "${loopVar}")).camundaInputParameter("constVar", "someValue")).boundaryEvent("MessageReceiver_1").message(TEST_MESSAGE_NAME)).userTask("UserTask_2").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        this.testHelper.deploy(model);
        HashMap<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
        variables.put("vars", Arrays.asList(1, 2, 3));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        HashMap<String, Object> correlationKeys = new HashMap<String, Object>();
        int correlationKey = 1;
        correlationKeys.put("localVar", correlationKey);
        correlationKeys.put("constVar", "someValue");
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("newVar", "newValue");
        MessageCorrelationResult messageCorrelationResult = this.engineRule.getRuntimeService().createMessageCorrelation(messageName).localVariablesEqual(correlationKeys).setVariables(messagePayload).correlateWithResult();
        this.checkExecutionMessageCorrelationResult(messageCorrelationResult, processInstance, "UserTask_1");
        List uncorrelatedExecutions = this.engineRule.getRuntimeService().createExecutionQuery().activityId("UserTask_1").list();
        Assert.assertEquals((long)2L, (long)uncorrelatedExecutions.size());
    }

    @Test
    public void testBothInstanceAndLocalVariableMessageCorrelation() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().receiveTask("MessageReceiver_1").message(TEST_MESSAGE_NAME)).userTask("UserTask_1").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        model = ModifiableBpmnModelInstance.modify(model).activityBuilder("MessageReceiver_1").camundaInputParameter("localVar", "${loopVar}").camundaInputParameter("constVar", "someValue").done();
        this.testHelper.deploy(model);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("vars", Arrays.asList(1, 2, 3));
        variables.put("processInstanceVar", "processInstanceVarValue");
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        variables = new HashMap();
        variables.put("vars", Arrays.asList(1, 2, 3));
        variables.put("processInstanceVar", "anotherProcessInstanceVarValue");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        HashMap<String, Object> correlationKeys = new HashMap<String, Object>();
        int correlationKey = 1;
        correlationKeys.put("localVar", correlationKey);
        correlationKeys.put("constVar", "someValue");
        HashMap<String, String> processInstanceKeys = new HashMap<String, String>();
        String processInstanceVarValue = "processInstanceVarValue";
        processInstanceKeys.put("processInstanceVar", processInstanceVarValue);
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("newVar", "newValue");
        MessageCorrelationResult messageCorrelationResult = this.engineRule.getRuntimeService().createMessageCorrelation(messageName).processInstanceVariablesEqual(processInstanceKeys).localVariablesEqual(correlationKeys).setVariables(messagePayload).correlateWithResult();
        this.checkExecutionMessageCorrelationResult(messageCorrelationResult, processInstance, "MessageReceiver_1");
        List uncorrelatedExecutions = this.engineRule.getRuntimeService().createExecutionQuery().activityId("MessageReceiver_1").list();
        Assert.assertEquals((long)5L, (long)uncorrelatedExecutions.size());
    }

    @Test
    public void testReceiveTaskMessageCorrelationFail() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().receiveTask("MessageReceiver_1").message(TEST_MESSAGE_NAME)).camundaInputParameter("localVar", "${loopVar}")).camundaInputParameter("constVar", "someValue")).userTask("UserTask_1").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        this.testHelper.deploy(model);
        HashMap<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
        variables.put("vars", Arrays.asList(1, 2, 1));
        this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        HashMap<String, Object> correlationKeys = new HashMap<String, Object>();
        int correlationKey = 1;
        correlationKeys.put("localVar", correlationKey);
        correlationKeys.put("constVar", "someValue");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMessageCorrelation(messageName).localVariablesEqual(correlationKeys).setVariables((Map)Variables.createVariables().putValue("newVar", (Object)"newValue")).correlateWithResult()).isInstanceOf(MismatchingMessageCorrelationException.class)).hasMessageContaining(String.format("Cannot correlate a message with name '%s' to a single execution", TEST_MESSAGE_NAME));
    }

    @Test
    public void testReceiveTaskMessageCorrelationAll() {
        BpmnModelInstance model = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"Process_1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().receiveTask("MessageReceiver_1").message(TEST_MESSAGE_NAME)).camundaInputParameter("localVar", "${loopVar}")).camundaInputParameter("constVar", "someValue")).userTask("UserTask_1").endEvent().subProcessDone().multiInstance().camundaCollection("${vars}")).camundaElementVariable("loopVar")).multiInstanceDone().endEvent().done();
        this.testHelper.deploy(model);
        HashMap<String, List<Integer>> variables = new HashMap<String, List<Integer>>();
        variables.put("vars", Arrays.asList(1, 2, 1));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_1", variables);
        String messageName = TEST_MESSAGE_NAME;
        HashMap<String, Object> correlationKeys = new HashMap<String, Object>();
        int correlationKey = 1;
        correlationKeys.put("localVar", correlationKey);
        correlationKeys.put("constVar", "someValue");
        List messageCorrelationResults = this.engineRule.getRuntimeService().createMessageCorrelation(messageName).localVariablesEqual(correlationKeys).setVariables((Map)Variables.createVariables().putValue("newVar", (Object)"newValue")).correlateAllWithResult();
        for (MessageCorrelationResult result : messageCorrelationResults) {
            this.checkExecutionMessageCorrelationResult(result, processInstance, "MessageReceiver_1");
        }
        List uncorrelatedExecutions = this.engineRule.getRuntimeService().createExecutionQuery().activityId("MessageReceiver_1").list();
        Assert.assertEquals((long)1L, (long)uncorrelatedExecutions.size());
    }

    protected void checkExecutionMessageCorrelationResult(MessageCorrelationResult result, ProcessInstance processInstance, String activityId) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)MessageCorrelationResultType.Execution, (Object)result.getResultType());
        Assert.assertEquals((Object)processInstance.getId(), (Object)result.getExecution().getProcessInstanceId());
        ExecutionEntity entity = (ExecutionEntity)result.getExecution();
        Assert.assertEquals((Object)activityId, (Object)entity.getActivityId());
    }
}

