/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionTree;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceModificationEventTest
extends PluggableProcessEngineTest {
    protected static final String INTERMEDIATE_TIMER_CATCH_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.intermediateTimerCatch.bpmn20.xml";
    protected static final String MESSAGE_START_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.messageStart.bpmn20.xml";
    protected static final String TIMER_START_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.timerStart.bpmn20.xml";
    protected static final String ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
    protected static final String TERMINATE_END_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.terminateEnd.bpmn20.xml";
    protected static final String CANCEL_END_EVENT_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.intermediateTimerCatch.bpmn20.xml"})
    @Test
    public void testStartBeforeIntermediateCatchEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("intermediateCatchEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("intermediateCatchEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child(null).concurrent().noScope().child("intermediateCatchEvent").scope().done());
        ActivityInstance catchEventInstance = this.getChildInstanceForActivity(updatedTree, "intermediateCatchEvent");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)catchEventInstance.getExecutionIds()[0], (Object)job.getExecutionId());
        this.completeTasksInOrder("task");
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.messageStart.bpmn20.xml"})
    @Test
    public void testStartBeforeMessageStartEvent() {
        this.runtimeService.correlateMessage("startMessage");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)processInstance);
        EventSubscription startEventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)startEventSubscription);
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("task").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child("task").concurrent().noScope().done());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)subscription);
        Assert.assertEquals((Object)startEventSubscription.getId(), (Object)subscription.getId());
        this.completeTasksInOrder("task", "task");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.timerStart.bpmn20.xml"})
    @Test
    public void testStartBeforeTimerStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Job startTimerJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)startTimerJob);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("task").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child("task").concurrent().noScope().done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)startTimerJob.getId(), (Object)job.getId());
        this.completeTasksInOrder("task", "task");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforNoneStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").concurrent().noScope().up().child("theTask").concurrent().noScope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeNoneEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        this.completeTasksInOrder("theTask");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.terminateEnd.bpmn20.xml"})
    @Test
    public void testStartBeforeTerminateEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("terminateEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNull((Object)updatedTree);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml"})
    @Test
    public void testStartBeforeCancelEndEventConcurrent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Task txTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"txTask", (Object)txTask.getTaskDefinitionKey());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("cancelEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterCancellation").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("afterCancellation").scope().done());
        Task afterCancellationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterCancellationTask);
        Assert.assertFalse((boolean)txTask.getId().equals(afterCancellationTask.getId()));
        Assert.assertEquals((Object)"afterCancellation", (Object)afterCancellationTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml"})
    @Test
    public void testStartBeforeCancelEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Task txTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"txTask", (Object)txTask.getTaskDefinitionKey());
        this.taskService.complete(txTask.getId(), (Map)Variables.createVariables().putValue("success", (Object)true));
        Task afterSuccessTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"afterSuccess", (Object)afterSuccessTask.getTaskDefinitionKey());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("cancelEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterCancellation").activity("afterSuccess").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("afterCancellation").concurrent().noScope().up().child("afterSuccess").concurrent().noScope().up().child("tx").scope().eventScope().done());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("undoTxTask").count());
        Task afterCancellationTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("afterCancellation").singleResult();
        Assert.assertNotNull((Object)afterCancellationTask);
        this.taskService.complete(afterCancellationTask.getId());
        this.taskService.complete(afterSuccessTask.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            if (!childInstance.getActivityId().equals(activityId)) continue;
            return childInstance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

