/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessInstanceQueryOrTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected List<String> deploymentIds = new ArrayList<String>();

    @Before
    public void init() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
        this.managementService = this.processEngineRule.getManagementService();
    }

    @After
    public void deleteDeployments() {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    @Test
    public void shouldThrowExceptionByMissingStartOr() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().endOr().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set endOr() before or()");
    }

    @Test
    public void shouldThrowExceptionByNesting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().or().endOr().endOr().or().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set or() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().orderByProcessInstanceId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().orderByProcessDefinitionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().orderByProcessDefinitionKey().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionKey() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOorderByTenantIdd() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().orderByTenantId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTenantId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByBusinessKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.createProcessInstanceQuery().or().orderByBusinessKey().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByBusinessKey() within 'or' query");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstWithEmptyOrQuery() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstWithVarValue1OrVarValue2() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar", (Object)"ghijkl").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstWithMultipleOrCriteria() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance2.getProcessInstanceId(), "aVarName", (Object)"varValue");
        vars = new HashMap();
        vars.put("stringVar2", "aaabbbaaa");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance3.getProcessInstanceId(), "bVarName", (Object)"bTestb");
        vars = new HashMap();
        vars.put("stringVar2", "cccbbbccc");
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance4.getProcessInstanceId(), "bVarName", (Object)"aTesta");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueLike("stringVar2", "%bbb%").processInstanceId(processInstance1.getId()).endOr().list();
        Assert.assertEquals((long)4L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstFilteredByMultipleOrAndCriteria() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().variableValueEquals("longVar", (Object)56789L).processInstanceId(processInstance1.getId()).endOr().variableValueEquals("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstFilteredByMultipleOrQueries() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 56789L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 12345L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        vars.put("boolVar", false);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        vars.put("boolVar", false);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("longVar", (Object)12345L).endOr().or().variableValueEquals("boolVar", (Object)true).variableValueEquals("longVar", (Object)12345L).endOr().or().variableValueEquals("stringVar", (Object)"ghijkl").variableValueEquals("longVar", (Object)56789L).endOr().or().variableValueEquals("stringVar", (Object)"ghijkl").variableValueEquals("boolVar", (Object)false).variableValueEquals("longVar", (Object)56789L).endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstWhereSameCriterionWasAppliedThreeTimesInOneQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().processInstanceId(processInstance1.getId()).processInstanceId(processInstance2.getId()).processInstanceId(processInstance3.getId()).endOr().list();
        Assert.assertEquals((long)1L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnProcInstWithVariableValueEqualsOrVariableValueGreaterThan() {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longerVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longerVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().or().variableValueEquals("longVar", (Object)12345L).variableValueGreaterThan("longerVar", (Object)20000L).endOr();
        Assert.assertEquals((long)3L, (long)query.count());
    }

    @Test
    public void shouldReturnProcInstWithProcessDefinitionNameOrProcessDefinitionKey() {
        BpmnModelInstance aProcessDefinition = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"aProcessDefinition").name("process1")).startEvent().userTask().endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().processDefinitionId(processInstance1.getProcessDefinitionId()).processDefinitionKey("anotherProcessDefinition").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    public void shouldReturnProcInstWithBusinessKeyOrBusinessKeyLike() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", "aBusinessKey");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition", "anotherBusinessKey");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().processInstanceBusinessKey("aBusinessKey").processInstanceBusinessKeyLike("anotherBusinessKey").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    public void shouldReturnProcInstByVariableAndActiveProcesses() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("testQuerySuspensionStateTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("foo", 0);
        ProcessInstance suspendedProcessInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.suspendProcessInstanceById(suspendedProcessInstance.getProcessInstanceId());
        List activeProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").active().list();
        List suspendedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").suspended().list();
        Assert.assertEquals((long)2L, (long)activeProcessInstances.size());
        Assert.assertEquals((long)1L, (long)suspendedProcessInstances.size());
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().active().variableValueEquals("foo", (Object)0).endOr().list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnByProcessDefinitionKeyOrActivityId() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aUserTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("process");
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().activityIdIn(new String[]{"theTask"}).processDefinitionKey("process").endOr().list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(2);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnByProcessDefinitionIdOrIncidentType() {
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessDefinitionId();
        BpmnModelInstance aProcessDefinition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("aUserTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        List processInstances = this.runtimeService.createProcessInstanceQuery().or().incidentType("failedJob").processDefinitionId(processDefinitionId).endOr().list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(2);
    }
}

