/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.eximeebpms.bpm.engine.impl.cfg.multitenancy.TenantIdProviderCaseInstanceContext;
import org.eximeebpms.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.eximeebpms.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.BatchRestartHelper;
import org.eximeebpms.bpm.engine.test.api.runtime.RestartProcessInstanceSyncTest;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.util.IncrementCounterListener;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class RestartProcessInstanceAsyncTest {
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchRestartHelper helper = new BatchRestartHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected TenantIdProvider defaultTenantIdProvider;
    protected boolean defaultEnsureJobDueDateSet;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.defaultTenantIdProvider = this.processEngineConfiguration.getTenantIdProvider();
        this.defaultEnsureJobDueDateSet = this.processEngineConfiguration.isEnsureJobDueDateNotNull();
    }

    @After
    public void reset() {
        this.helper.removeAllRunningAndHistoricBatches();
        this.processEngineConfiguration.setTenantIdProvider(this.defaultTenantIdProvider);
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @Test
    public void createBatchRestart() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        List<String> processInstanceIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startAfterActivity("userTask2")).processInstanceIds(processInstanceIds).executeAsync();
        this.assertBatchCreated(batch, 2);
    }

    @Test
    public void restartProcessInstanceWithNullProcessDefinitionId() {
        try {
            this.runtimeService.restartProcessInstances(null).executeAsync();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"processDefinitionId is null"});
        }
    }

    @Test
    public void restartProcessInstanceWithoutInstructions() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        try {
            Batch batch = this.runtimeService.restartProcessInstances(processDefinition.getId()).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
            this.helper.completeBatch(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"instructions is empty"});
        }
    }

    @Test
    public void restartProcessInstanceWithoutProcessInstanceIds() {
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances("foo").startAfterActivity("bar")).executeAsync();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"processInstanceIds is empty"});
        }
    }

    @Test
    public void restartProcessInstanceWithNullProcessInstanceId() {
        try {
            ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances("foo").startAfterActivity("bar")).processInstanceIds(new String[]{null}).executeAsync();
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"processInstanceIds contains null value"});
        }
    }

    @Test
    public void restartNotExistingProcessInstance() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("bar")).processInstanceIds(new String[]{"aaa"}).executeAsync();
        this.helper.completeSeedJobs(batch);
        try {
            this.helper.executeJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Historic process instance cannot be found"});
        }
    }

    @Test
    public void shouldRestartProcessInstance() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).active().singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).active().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.getExecutionJobs(batch).forEach(j -> Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)j.getDeploymentId()));
        this.helper.completeExecutionJobs(batch);
        this.helper.completeMonitorJobs(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().active().list();
        ProcessInstance restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(0);
        Task restartedTask = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)task1.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
        restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(1);
        restartedTask = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)task2.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
    }

    @Test
    public void shouldAssignRestartProcessInstanceIdOnlyToRestartedProcessInstances() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.getExecutionJobs(batch).forEach(j -> Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)j.getDeploymentId()));
        this.helper.completeExecutionJobs(batch);
        this.helper.completeMonitorJobs(batch);
        ProcessInstance restartedProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().singleResult();
        HistoricProcessInstanceEntity historicProcessInstance1 = (HistoricProcessInstanceEntity)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(restartedProcessInstance.getId()).singleResult();
        HistoricProcessInstanceEntity historicProcessInstance2 = (HistoricProcessInstanceEntity)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance2.getId()).singleResult();
        Assertions.assertThat((String)historicProcessInstance1.getRestartedProcessInstanceId()).isEqualTo((Object)processInstance1.getId());
        Assertions.assertThat((String)historicProcessInstance2.getRestartedProcessInstanceId()).isNull();
    }

    @Test
    public void shouldRestartProcessInstanceWithParallelGateway() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).startBeforeActivity("userTask2")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().active().list();
        for (ProcessInstance restartedProcessInstance : restartedProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("userTask1").activity("userTask2").done());
        }
    }

    @Test
    public void shouldRestartProcessInstanceWithSubProcess() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("subProcess")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().active().list();
        for (ProcessInstance restartedProcessInstance : restartedProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).beginScope("subProcess").activity("userTask").done());
        }
    }

    @Test
    public void shouldRestartProcessInstanceWithInitialVariables() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask1").camundaExecutionListenerClass("end", RestartProcessInstanceSyncTest.SetVariableExecutionListenerImpl.class.getName())).userTask("userTask2").endEvent().done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("var", (Object)"bar"));
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("var", (Object)"bar"));
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processDefinition.getId()).active().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).initialSetOfVariables().processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        VariableInstance variableInstance1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{((ProcessInstance)restartedProcessInstances.get(0)).getId()}).singleResult();
        VariableInstance variableInstance2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{((ProcessInstance)restartedProcessInstances.get(1)).getId()}).singleResult();
        Assert.assertEquals((Object)variableInstance1.getExecutionId(), (Object)((ProcessInstance)restartedProcessInstances.get(0)).getId());
        Assert.assertEquals((Object)variableInstance2.getExecutionId(), (Object)((ProcessInstance)restartedProcessInstances.get(1)).getId());
        Assert.assertEquals((Object)"var", (Object)variableInstance1.getName());
        Assert.assertEquals((Object)"bar", (Object)variableInstance1.getValue());
        Assert.assertEquals((Object)"var", (Object)variableInstance2.getName());
        Assert.assertEquals((Object)"bar", (Object)variableInstance2.getValue());
    }

    @Test
    public void shouldRestartProcessInstanceWithVariables() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask1").camundaExecutionListenerClass("end", RestartProcessInstanceSyncTest.SetVariableExecutionListenerImpl.class.getName())).userTask("userTask2").endEvent().done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.setVariable(processInstance1.getId(), "var", (Object)"bar");
        this.runtimeService.setVariable(processInstance2.getId(), "var", (Object)"bb");
        List tasks = this.taskService.createTaskQuery().processDefinitionId(processDefinition.getId()).active().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().active().list();
        ProcessInstance restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(0);
        VariableInstance variableInstance1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).singleResult();
        Assert.assertEquals((Object)variableInstance1.getExecutionId(), (Object)restartedProcessInstance.getId());
        restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(1);
        VariableInstance variableInstance2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{restartedProcessInstance.getId()}).singleResult();
        Assert.assertEquals((Object)variableInstance2.getExecutionId(), (Object)restartedProcessInstance.getId());
        Assert.assertTrue((boolean)variableInstance1.getName().equals(variableInstance2.getName()));
        Assert.assertEquals((Object)"var", (Object)variableInstance1.getName());
        Assert.assertTrue((boolean)variableInstance1.getValue().equals(variableInstance2.getValue()));
        Assert.assertEquals((Object)"foo", (Object)variableInstance2.getValue());
    }

    @Test
    public void shouldNotSetLocalVariables() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        Execution subProcess1 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance1.getId()).activityId("userTask").singleResult();
        Execution subProcess2 = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance2.getId()).activityId("userTask").singleResult();
        this.runtimeService.setVariableLocal(subProcess1.getId(), "local", (Object)"foo");
        this.runtimeService.setVariableLocal(subProcess2.getId(), "local", (Object)"foo");
        this.runtimeService.setVariable(processInstance1.getId(), "var", (Object)"bar");
        this.runtimeService.setVariable(processInstance2.getId(), "var", (Object)"bar");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        List variables1 = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{((ProcessInstance)restartedProcessInstances.get(0)).getId()}).list();
        Assert.assertEquals((long)1L, (long)variables1.size());
        Assert.assertEquals((Object)"var", (Object)((VariableInstance)variables1.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)variables1.get(0)).getValue());
        List variables2 = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{((ProcessInstance)restartedProcessInstances.get(1)).getId()}).list();
        Assert.assertEquals((long)1L, (long)variables1.size());
        Assert.assertEquals((Object)"var", (Object)((VariableInstance)variables2.get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((VariableInstance)variables2.get(0)).getValue());
    }

    @Test
    public void shouldRestartProcessInstanceUsingHistoricProcessInstanceQuery() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).active().singleResult();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).active().singleResult();
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).historicProcessInstanceQuery(historicProcessInstanceQuery).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().active().list();
        ProcessInstance restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(0);
        Task restartedTask = (Task)this.taskService.createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)task1.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
        restartedProcessInstance = (ProcessInstance)restartedProcessInstances.get(1);
        restartedTask = (Task)this.taskService.createTaskQuery().processInstanceId(restartedProcessInstance.getId()).active().singleResult();
        Assert.assertEquals((Object)task2.getTaskDefinitionKey(), (Object)restartedTask.getTaskDefinitionKey());
    }

    @Test
    public void testBatchCreationWithOverlappingProcessInstanceIdsAndQuery() {
        int processInstanceCount = 2;
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        HistoricProcessInstanceQuery processInstanceQuery = this.engineRule.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).historicProcessInstanceQuery(processInstanceQuery).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list();
        Assert.assertEquals((long)restartedProcessInstances.size(), (long)processInstanceCount);
    }

    @Test
    public void testMonitorJobPollingForCompletion() {
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        Date createDate = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
        Assert.assertNull((Object)monitorJob.getDuedate());
        this.helper.executeMonitorJob(batch);
        monitorJob = this.helper.getMonitorJob(batch);
        Date dueDate = this.helper.addSeconds(createDate, 30);
        Assert.assertEquals((Object)dueDate, (Object)monitorJob.getDuedate());
    }

    @Test
    public void testMonitorJobPollingForCompletionDueDateSet() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(true);
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
        Assert.assertEquals((Object)TEST_DATE, (Object)monitorJob.getDuedate());
        this.helper.executeMonitorJob(batch);
        monitorJob = this.helper.getMonitorJob(batch);
        Date dueDate = this.helper.addSeconds(TEST_DATE, 30);
        Assert.assertEquals((Object)dueDate, (Object)monitorJob.getDuedate());
    }

    @Test
    public void testMonitorJobRemovesBatchAfterCompletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithoutCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.engineRule.getManagementService().deleteBatch(batch.getId(), false);
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchWithFailedSeedJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        Job seedJob = this.helper.getSeedJob(batch);
        this.engineRule.getManagementService().setJobRetries(seedJob.getId(), 0);
        this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.engineRule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedExecutionJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        for (Job executionJob : executionJobs) {
            this.engineRule.getManagementService().setJobRetries(executionJob.getId(), 0);
        }
        this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.engineRule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedMonitorJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        this.engineRule.getManagementService().setJobRetries(monitorJob.getId(), 0);
        this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.engineRule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobsExecutionByJobExecutorWithAuthorizationEnabledAndTenant() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setAuthorizationEnabled(true);
        ProcessDefinition processDefinition = this.testRule.deployForTenantAndGetDefinition("tenantId", ProcessModels.TWO_TASKS_PROCESS);
        try {
            ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
            ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
            List<String> list = Arrays.asList(processInstance1.getId(), processInstance2.getId());
            this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
            this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
            Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startTransition("flow1")).processInstanceIds(list).executeAsync();
            this.helper.completeSeedJobs(batch);
            this.testRule.waitForJobExecutorToProcessAllJobs();
            List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list();
            for (ProcessInstance restartedProcessInstance : restartedProcessInstances) {
                ActivityInstance updatedTree = this.runtimeService.getActivityInstance(restartedProcessInstance.getId());
                Assert.assertNotNull((Object)updatedTree);
                Assert.assertEquals((Object)restartedProcessInstance.getId(), (Object)updatedTree.getProcessInstanceId());
                Assert.assertEquals((Object)"tenantId", (Object)restartedProcessInstance.getTenantId());
                ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("userTask2").done());
            }
        }
        finally {
            processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    @Test
    public void restartProcessInstanceWithNotMatchingProcessDefinition() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        BpmnModelInstance instance2 = Bpmn.createExecutableProcess().startEvent().done();
        ProcessDefinition processDefinition2 = this.testRule.deployAndGetDefinition(instance2);
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition2.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
        try {
            this.helper.completeBatch(batch);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Its process definition '" + processDefinition.getId() + "' does not match given process definition '" + processDefinition2.getId() + "'"});
        }
    }

    @Test
    public void shouldRestartProcessInstanceWithoutBusinessKey() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process", "businessKey1", (String)null);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process", "businessKey2", (String)null);
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).withoutBusinessKey().executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        ProcessInstance restartedProcessInstance1 = (ProcessInstance)restartedProcessInstances.get(0);
        ProcessInstance restartedProcessInstance2 = (ProcessInstance)restartedProcessInstances.get(1);
        Assert.assertNull((Object)restartedProcessInstance1.getBusinessKey());
        Assert.assertNull((Object)restartedProcessInstance2.getBusinessKey());
    }

    @Test
    public void shouldRestartProcessInstanceWithBusinessKey() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process", "businessKey1", (String)null);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process", "businessKey2", (String)null);
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        ProcessInstance restartedProcessInstance1 = (ProcessInstance)restartedProcessInstances.get(0);
        ProcessInstance restartedProcessInstance2 = (ProcessInstance)restartedProcessInstances.get(1);
        Assert.assertNotNull((Object)restartedProcessInstance1.getBusinessKey());
        Assert.assertNotNull((Object)restartedProcessInstance2.getBusinessKey());
    }

    @Test
    public void shouldRestartProcessInstanceWithoutCaseInstanceId() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process", null, "caseInstanceId1");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process", null, "caseInstanceId2");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        ProcessInstance restartedProcessInstance1 = (ProcessInstance)restartedProcessInstances.get(0);
        ProcessInstance restartedProcessInstance2 = (ProcessInstance)restartedProcessInstances.get(1);
        Assert.assertNull((Object)restartedProcessInstance1.getCaseInstanceId());
        Assert.assertNull((Object)restartedProcessInstance2.getCaseInstanceId());
    }

    @Test
    public void shouldRestartProcessInstanceWithTenant() {
        ProcessDefinition processDefinition = this.testRule.deployForTenantAndGetDefinition("tenantId", ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).active().list();
        Assert.assertNotNull((Object)((ProcessInstance)restartedProcessInstances.get(0)).getTenantId());
        Assert.assertNotNull((Object)((ProcessInstance)restartedProcessInstances.get(1)).getTenantId());
        Assert.assertEquals((Object)"tenantId", (Object)((ProcessInstance)restartedProcessInstances.get(0)).getTenantId());
        Assert.assertEquals((Object)"tenantId", (Object)((ProcessInstance)restartedProcessInstances.get(1)).getTenantId());
    }

    @Test
    public void shouldSkipCustomListeners() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).activityBuilder("userTask1").camundaExecutionListenerClass("start", IncrementCounterListener.class.getName()).done());
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        IncrementCounterListener.counter = 0;
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).skipCustomListeners().executeAsync();
        this.helper.completeBatch(batch);
        Assert.assertEquals((long)0L, (long)IncrementCounterListener.counter);
    }

    @Test
    public void shouldSkipIoMappings() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.TWO_TASKS_PROCESS).activityBuilder("userTask1").camundaInputParameter("foo", "bar").done());
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).skipIoMappings().processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list();
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(((ProcessInstance)restartedProcessInstances.get(0)).getId()).activityId("userTask1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertNull((Object)this.runtimeService.getVariable(task1Execution.getId(), "foo"));
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(((ProcessInstance)restartedProcessInstances.get(1)).getId()).activityId("userTask1").singleResult();
        Assert.assertNotNull((Object)task1Execution);
        Assert.assertNull((Object)this.runtimeService.getVariable(task1Execution.getId(), "foo"));
    }

    @Test
    public void shouldRetainTenantIdOfSharedProcessDefinition() {
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new TestTenantIdProvider());
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((Object)processInstance.getTenantId(), (Object)"testTenantId");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)"testTenantId");
    }

    @Test
    public void shouldSkipTenantIdProviderOnRestart() {
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new TestTenantIdProvider());
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Assert.assertEquals((Object)processInstance.getTenantId(), (Object)"testTenantId");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        this.engineRule.getProcessEngineConfiguration().setTenantIdProvider((TenantIdProvider)new FailingTenantIdProvider());
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask")).processInstanceIds(new String[]{processInstance.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        ProcessInstance restartedInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().active().processDefinitionId(processDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)restartedInstance);
        Assert.assertEquals((Object)restartedInstance.getTenantId(), (Object)"testTenantId");
    }

    @Test
    public void shouldNotSetInitialVariablesIfThereIsNoUniqueStartActivity() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).startBeforeActivity("userTask2")).startBeforeActivity("userTask1")).execute();
        ProcessInstance processInstance2 = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).startBeforeActivity("userTask1")).startBeforeActivity("userTask2")).setVariable("foo", (Object)"bar")).execute();
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startBeforeActivity("userTask1")).initialSetOfVariables().processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeBatch(batch);
        List restartedProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list();
        List variables = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{((ProcessInstance)restartedProcessInstances.get(0)).getId(), ((ProcessInstance)restartedProcessInstances.get(1)).getId()}).list();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("instance-restart", 42);
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("Process");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        List<String> processInstanceIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startAfterActivity("userTask2")).processInstanceIds(processInstanceIds).executeAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    public void shouldSetExecutionStartTimeInBatchAndHistory() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).startBeforeActivity("userTask1")).execute();
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        Batch batch = ((RestartProcessInstanceBuilder)this.runtimeService.restartProcessInstances(processDefinition.getId()).startAfterActivity("userTask2")).processInstanceIds(new String[]{processInstance1.getId()}).executeAsync();
        this.helper.executeSeedJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        this.helper.executeJob(executionJobs.get(0));
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        batch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assertions.assertThat((Date)batch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        Assertions.assertThat((Date)historicBatch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
    }

    protected void assertBatchCreated(Batch batch, int processInstanceCount) {
        Assert.assertNotNull((Object)batch);
        Assert.assertNotNull((Object)batch.getId());
        Assert.assertEquals((Object)"instance-restart", (Object)batch.getType());
        Assert.assertEquals((long)processInstanceCount, (long)batch.getTotalJobs());
    }

    public static class TestTenantIdProvider
    extends FailingTenantIdProvider {
        static final String TENANT_ID = "testTenantId";

        @Override
        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return TENANT_ID;
        }
    }

    public static class FailingTenantIdProvider
    implements TenantIdProvider {
        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

