/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RootProcessInstanceTest {
    protected final String CALLED_PROCESS_KEY = "calledProcess";
    protected final BpmnModelInstance CALLED_PROCESS = Bpmn.createExecutableProcess((String)"calledProcess").startEvent().userTask("userTask").endEvent().done();
    protected final String CALLED_AND_CALLING_PROCESS_KEY = "calledAndCallingProcess";
    protected final BpmnModelInstance CALLED_AND_CALLING_PROCESS = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"calledAndCallingProcess").startEvent().callActivity().calledElement("calledProcess")).endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("calledAndCallingProcess")).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected FormService formService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.formService = this.engineRule.getFormService();
    }

    @Test
    public void shouldPointToItself() {
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("calledProcess");
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldPointToItselfBySubmittingStartForm() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.CALLED_PROCESS);
        String processDefinitionId = ((ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0)).getId();
        HashMap properties = new HashMap();
        ProcessInstance processInstance = this.formService.submitStartForm(processDefinitionId, properties);
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldPointToItselfByStartingAtActivity() {
        this.testRule.deploy(this.CALLED_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("calledProcess").startAfterActivity("userTask")).execute();
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)processInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldPointToRoot() {
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLED_AND_CALLING_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ProcessInstance calledProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("calledProcess").singleResult();
        ProcessInstance calledAndCallingProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("calledAndCallingProcess").singleResult();
        ProcessInstance callingProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callingProcess").singleResult();
        MatcherAssert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)3L));
        MatcherAssert.assertThat((Object)callingProcessInstance.getRootProcessInstanceId(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)callingProcessInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)calledProcessInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)calledAndCallingProcessInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
    }

    @Test
    public void shouldPointToRootWithInitialCallAfterParallelGateway() {
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLED_AND_CALLING_PROCESS);
        this.testRule.deploy(((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcessWithGateway").startEvent().parallelGateway("split").callActivity().calledElement("calledAndCallingProcess")).moveToNode("split").callActivity().calledElement("calledAndCallingProcess")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcessWithGateway");
        List calledProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("calledProcess").list();
        List calledAndCallingProcessInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("calledAndCallingProcess").list();
        ProcessInstance callingProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callingProcessWithGateway").singleResult();
        MatcherAssert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)5L));
        MatcherAssert.assertThat((Object)callingProcessInstance.getProcessInstanceId(), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)calledProcessInstances.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)calledAndCallingProcessInstances.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)callingProcessInstance.getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((ProcessInstance)calledProcessInstances.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((ProcessInstance)calledProcessInstances.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((ProcessInstance)calledAndCallingProcessInstances.get(0)).getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)((ProcessInstance)calledAndCallingProcessInstances.get(1)).getRootProcessInstanceId(), (Matcher)Is.is((Object)callingProcessInstance.getProcessInstanceId()));
    }
}

