/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.util.SetBusinessKeyListener;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class SetBusinessKeyTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected static final String PROCESS_KEY = "process";
    protected static final BpmnModelInstance SYNC_SERVICE_TASK_PROCESS = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask().camundaClass(SetBusinessKeyDelegate.class)).userTask("userTask2").endEvent("endEvent").done();
    protected static final BpmnModelInstance ASYNC_SERVICE_TASK_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask().camundaAsyncBefore()).camundaClass(SetBusinessKeyDelegate.class)).userTask("userTask2").endEvent("endEvent").done();
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
        this.historyService = this.rule.getHistoryService();
        this.managementService = this.rule.getManagementService();
    }

    @Test
    public void testNewKeyInSyncServiceTask() {
        this.testRule.deploy(SYNC_SERVICE_TASK_PROCESS);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInAsyncServiceTask() {
        this.testRule.deploy(ASYNC_SERVICE_TASK_PROCESS);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.executeJob();
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInStartExecListener() {
        String listener = "start";
        BpmnModelInstance process = this.createModelExecutionListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInEndExecListener() {
        String listener = "end";
        BpmnModelInstance process = this.createModelExecutionListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.completeTask("userTask1");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult());
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInStartTaskListener() {
        String listener = "create";
        BpmnModelInstance process = this.createModelTaskListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInAssignTaskListener() {
        String listener = "assignment";
        BpmnModelInstance process = this.createModelTaskListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.taskService.setAssignee(((Task)this.taskService.createTaskQuery().singleResult()).getId(), "newUserId");
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testNewKeyInEndTaskListener() {
        String listener = "complete";
        BpmnModelInstance process = this.createModelTaskListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.completeTask("userTask1");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult());
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    @Deployment
    public void testNewKeyInTimeoutTaskListener() {
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        ClockUtil.offset((Long)TimeUnit.MINUTES.toMillis(70L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyInSyncServiceTask() {
        this.testRule.deploy(SYNC_SERVICE_TASK_PROCESS);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyInAsyncServiceTask() {
        this.testRule.deploy(ASYNC_SERVICE_TASK_PROCESS);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.executeJob();
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyInStartExecListener() {
        String listener = "start";
        BpmnModelInstance process = this.createModelExecutionListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyInEndExecListener() {
        String listener = "end";
        BpmnModelInstance process = this.createModelExecutionListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.completeTask("userTask1");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult());
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyInEndTaskListener() {
        String listener = "complete";
        BpmnModelInstance process = this.createModelTaskListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = "newBusinessKey";
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", (Object)newBusinessKeyValue));
        this.completeTask("userTask1");
        Assert.assertNotNull((Object)this.taskService.createTaskQuery().taskDefinitionKey("userTask2").singleResult());
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    @Test
    public void testUpdateKeyNullValueInStartTaskListener() {
        String listener = "create";
        BpmnModelInstance process = this.createModelTaskListener(listener);
        this.testRule.deploy(process);
        String newBusinessKeyValue = null;
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, "aBusinessKey", (Map)Variables.createVariables().putValue("businessKeyVar", newBusinessKeyValue));
        this.checkBusinessKeyChanged(newBusinessKeyValue);
    }

    protected void checkBusinessKeyChanged(String newBusinessKeyValue) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_KEY).singleResult();
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)newBusinessKeyValue, (Object)processInstance.getBusinessKey());
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicInstance);
        Assert.assertEquals((Object)newBusinessKeyValue, (Object)historicInstance.getBusinessKey());
    }

    protected BpmnModelInstance createModelExecutionListener(String listener) {
        return ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent("startEvent").userTask("userTask1").name("User task")).camundaExecutionListenerExpression(listener, "${execution.setProcessBusinessKey(execution.getVariable(\"businessKeyVar\"))}")).userTask("userTask2").endEvent("endEvent").done();
    }

    protected BpmnModelInstance createModelTaskListener(String listener) {
        return ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent("startEvent").userTask("userTask1").name("User task")).camundaTaskListenerClass(listener, SetBusinessKeyListener.class)).userTask("userTask2").endEvent("endEvent").done();
    }

    protected void executeJob() {
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
    }

    protected void completeTask(String key) {
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey(key).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    public static class SetBusinessKeyDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            String newKeyValue = (String)execution.getVariable("businessKeyVar");
            execution.setProcessBusinessKey(newKeyValue);
        }
    }
}

