/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Java6Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.eximeebpms.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.FileValue;
import org.eximeebpms.bpm.engine.variable.value.ObjectValue;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.Assert;
import org.junit.Test;

public class VariableInstanceQueryTest
extends PluggableProcessEngineTest {
    protected static String PROC_DEF_KEY = "oneTaskProcess";

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQuery() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assert.assertNotNull((Object)query);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertNotNull((Object)var.getId());
            if (var.getName().equals("intVar")) {
                Assert.assertEquals((Object)"intVar", (Object)var.getName());
                Assert.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    public void testQueryByVariableId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "test");
        variables.put("var2", "test");
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstance result = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        Assert.assertNotNull((Object)result);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableId(result.getId());
        Assert.assertNotNull((Object)query);
        VariableInstance resultById = (VariableInstance)query.singleResult();
        Assert.assertEquals((Object)result.getId(), (Object)resultById.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableName() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("stringVar");
        this.verifyQueryResult(query, "test");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNames() {
        String variableValue = "a";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("process", variableValue);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "task", (Object)variableValue);
        this.runtimeService.setVariableLocal(task.getExecutionId(), "execution", (Object)variableValue);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameIn(new String[]{"task", "process", "execution"});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance variableInstance : result) {
            Assert.assertEquals((Object)variableValue, (Object)variableInstance.getValue());
            Assert.assertEquals((Object)"string", (Object)variableInstance.getTypeName());
        }
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("task").variableNameIn(new String[]{"task", "execution"}).count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("task").variableNameIn(new String[]{"process", "execution"}).count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNameLike() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("string%Var", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameLike("%ing\\%V%");
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"string%Var", (Object)var.getName());
        Assert.assertEquals((Object)"test", (Object)var.getValue());
        Assert.assertEquals((Object)"string", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableName_EmptyString() {
        String varName = "testVar";
        VariableMap variables = Variables.putValue((String)varName, (Object)"");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, (Map)variables);
        VariableInstance var = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(varName).singleResult();
        Java6Assertions.assertThat((Object)var.getValue()).isNotNull();
        Java6Assertions.assertThat((Object)var.getValue()).isEqualTo((Object)"");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableNameLikeWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableNameLike("%ingV_");
        List result = query.list();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_String() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("stringVar", (Object)"test");
        this.verifyQueryResult(query, "test");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_EmptyString() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("stringVar", (Object)"");
        this.verifyQueryResult(query, "");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("stringVar", (Object)"test123");
        this.verifyQueryResult(query, "test");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_EmptyString() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("stringVar", (Object)"");
        this.verifyQueryResult(query, "test");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueGreaterThan_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("stringVar", (Object)"a");
        this.verifyQueryResult(query, "b", "c");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueGreaterThanOrEqual_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"a");
        this.verifyQueryResult(query, "a", "b", "c");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLessThan_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("stringVar", (Object)"c");
        this.verifyQueryResult(query, "b", "a");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLessThanOrEqual_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "a");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "b");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "c");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"c");
        this.verifyQueryResult(query, "a", "b", "c");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLike_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test456");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("stringVar", "test789");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLike("stringVar", "test%");
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"stringVar", (Object)var.getName());
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getValue().equals("test123")) {
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("test456")) {
                Assert.assertEquals((Object)"test456", (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals("test789")) {
                Assert.assertEquals((Object)"test789", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueLikeWithEscape_String() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test_123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test%456");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLike("stringVar", "test\\_%");
        this.verifyQueryResult(query, "test_123");
        query = this.runtimeService.createVariableInstanceQuery().variableValueLike("stringVar", "test\\%%");
        this.verifyQueryResult(query, "test%456");
    }

    private void verifyQueryResult(VariableInstanceQuery query, String ... varValues) {
        Assert.assertEquals((long)varValues.length, (long)query.count());
        List result = query.list();
        Assert.assertEquals((long)varValues.length, (long)result.size());
        List<String> expected = Arrays.asList(varValues);
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"stringVar", (Object)var.getName());
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            Assert.assertTrue((String)("Unexpected value found: " + var.getValue()), (boolean)expected.contains(var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Integer() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("intValue", (Object)1234);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"intValue", (Object)var.getName());
        Assert.assertEquals((Object)1234, (Object)var.getValue());
        Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("intValue", (Object)5555);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"intValue", (Object)var.getName());
        Assert.assertEquals((Object)1234, (Object)var.getValue());
        Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("intValue", (Object)1234);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"intValue", (Object)var.getName());
            Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
            if (var.getValue().equals(5555)) {
                Assert.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                Assert.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("intValue", (Object)1234);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"intValue", (Object)var.getName());
            Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
            if (var.getValue().equals(1234)) {
                Assert.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(5555)) {
                Assert.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                Assert.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("intValue", (Object)9876);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"intValue", (Object)var.getName());
            Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
            if (var.getValue().equals(5555)) {
                Assert.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(1234)) {
                Assert.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Integer() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intValue", 1234);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Integer> variables2 = new HashMap<String, Integer>();
        variables2.put("intValue", 5555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Integer> variables3 = new HashMap<String, Integer>();
        variables3.put("intValue", 9876);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("intValue", (Object)9876);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"intValue", (Object)var.getName());
            Assert.assertEquals((Object)"integer", (Object)var.getTypeName());
            if (var.getValue().equals(1234)) {
                Assert.assertEquals((Object)1234, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(5555)) {
                Assert.assertEquals((Object)5555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(9876)) {
                Assert.assertEquals((Object)9876, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Long() {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("longValue", (Object)123456L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"longValue", (Object)var.getName());
        Assert.assertEquals((Object)123456L, (Object)var.getValue());
        Assert.assertEquals((Object)"long", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("longValue", (Object)987654L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"longValue", (Object)var.getName());
        Assert.assertEquals((Object)123456L, (Object)var.getValue());
        Assert.assertEquals((Object)"long", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("longValue", (Object)123456L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"longValue", (Object)var.getName());
            Assert.assertEquals((Object)"long", (Object)var.getTypeName());
            if (var.getValue().equals(555555L)) {
                Assert.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                Assert.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("longValue", (Object)123456L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"longValue", (Object)var.getName());
            Assert.assertEquals((Object)"long", (Object)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                Assert.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                Assert.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                Assert.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("longValue", (Object)987654L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"longValue", (Object)var.getName());
            Assert.assertEquals((Object)"long", (Object)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                Assert.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                Assert.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Long() {
        HashMap<String, Long> variables1 = new HashMap<String, Long>();
        variables1.put("longValue", 123456L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Long> variables2 = new HashMap<String, Long>();
        variables2.put("longValue", 987654L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Long> variables3 = new HashMap<String, Long>();
        variables3.put("longValue", 555555L);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("longValue", (Object)987654L);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"longValue", (Object)var.getName());
            Assert.assertEquals((Object)"long", (Object)var.getTypeName());
            if (var.getValue().equals(123456L)) {
                Assert.assertEquals((Object)123456L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(555555L)) {
                Assert.assertEquals((Object)555555L, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(987654L)) {
                Assert.assertEquals((Object)987654L, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Double() {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("doubleValue", (Object)123.456);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
        Assert.assertEquals((Object)123.456, (Object)var.getValue());
        Assert.assertEquals((Object)"double", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueNotEquals_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("doubleValue", (Object)654.321);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
        Assert.assertEquals((Object)123.456, (Object)var.getValue());
        Assert.assertEquals((Object)"double", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("doubleValue", (Object)123.456);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
            Assert.assertEquals((Object)"double", (Object)var.getTypeName());
            if (var.getValue().equals(654.321)) {
                Assert.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                Assert.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("doubleValue", (Object)123.456);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
            Assert.assertEquals((Object)"double", (Object)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                Assert.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                Assert.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                Assert.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("doubleValue", (Object)999.999);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
            Assert.assertEquals((Object)"double", (Object)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                Assert.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                Assert.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Double() {
        HashMap<String, Double> variables1 = new HashMap<String, Double>();
        variables1.put("doubleValue", 123.456);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Double> variables2 = new HashMap<String, Double>();
        variables2.put("doubleValue", 654.321);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Double> variables3 = new HashMap<String, Double>();
        variables3.put("doubleValue", 999.999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("doubleValue", (Object)999.999);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"doubleValue", (Object)var.getName());
            Assert.assertEquals((Object)"double", (Object)var.getTypeName());
            if (var.getValue().equals(123.456)) {
                Assert.assertEquals((Object)123.456, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(654.321)) {
                Assert.assertEquals((Object)654.321, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals(999.999)) {
                Assert.assertEquals((Object)999.999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Short() {
        HashMap<String, Short> variables = new HashMap<String, Short>();
        variables.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("shortValue", (Object)123);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"shortValue", (Object)var.getName());
        Assert.assertEquals((Object)123, (Object)var.getValue());
        Assert.assertEquals((Object)"short", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableValueNotEquals_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("shortValue", (Object)999);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"shortValue", (Object)var.getName());
        Assert.assertEquals((Object)123, (Object)var.getValue());
        Assert.assertEquals((Object)"short", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThan_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThan("shortValue", (Object)123);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"shortValue", (Object)var.getName());
            Assert.assertEquals((Object)"short", (Object)var.getTypeName());
            if (var.getValue().equals((short)555)) {
                Assert.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                Assert.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableGreaterThanAndEqual_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueGreaterThanOrEqual("shortValue", (Object)123);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"shortValue", (Object)var.getName());
            Assert.assertEquals((Object)"short", (Object)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                Assert.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                Assert.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                Assert.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThan_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThan("shortValue", (Object)999);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"shortValue", (Object)var.getName());
            Assert.assertEquals((Object)"short", (Object)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                Assert.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                Assert.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableLessThanAndEqual_Short() {
        HashMap<String, Short> variables1 = new HashMap<String, Short>();
        variables1.put("shortValue", (short)123);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("shortValue", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, Short> variables3 = new HashMap<String, Short>();
        variables3.put("shortValue", (short)555);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueLessThanOrEqual("shortValue", (Object)999);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"shortValue", (Object)var.getName());
            Assert.assertEquals((Object)"short", (Object)var.getTypeName());
            if (var.getValue().equals((short)123)) {
                Assert.assertEquals((Object)123, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)555)) {
                Assert.assertEquals((Object)555, (Object)var.getValue());
                continue;
            }
            if (var.getValue().equals((short)999)) {
                Assert.assertEquals((Object)999, (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Bytes() {
        byte[] bytes = "somebytes".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("bytesVar", bytes);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("bytesVar", (Object)bytes);
        try {
            query.list();
            Assert.fail((String)"A ProcessEngineException was expected: Variables of type ByteArray cannot be used to query.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_Date() {
        Date now = new Date();
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("date", now);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("date", (Object)now);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"date", (Object)var.getName());
        Assert.assertEquals((Object)now, (Object)var.getValue());
        Assert.assertEquals((Object)"date", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEqualsWihtoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("stringVar", (Object)"notFoundValue");
        List result = query.list();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNameAndVariableValueEquals_NullValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("nullValue", null);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueEquals("nullValue", null);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"nullValue", (Object)var.getName());
        Assert.assertEquals(null, (Object)var.getValue());
        Assert.assertEquals((Object)"null", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableValueNotEquals_NullValue() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("value", null);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, Short> variables2 = new HashMap<String, Short>();
        variables2.put("value", (short)999);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("value", "abc");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableValueNotEquals("value", null);
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"value", (Object)var.getName());
            if (var.getValue().equals((short)999)) {
                Assert.assertEquals((Object)999, (Object)var.getValue());
                Assert.assertEquals((Object)"short", (Object)var.getTypeName());
                continue;
            }
            if (var.getValue().equals("abc")) {
                Assert.assertEquals((Object)"abc", (Object)var.getValue());
                Assert.assertEquals((Object)"string", (Object)var.getTypeName());
                continue;
            }
            Assert.fail((String)("A non expected value occured: " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("myVar")) {
                Assert.assertEquals((Object)"myVar", (Object)var.getName());
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("myVar")) {
                Assert.assertEquals((Object)"myVar", (Object)var.getName());
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{"aProcessInstanceId"});
        List result = query.list();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("myVar")) {
                Assert.assertEquals((Object)"myVar", (Object)var.getName());
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)3L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("myVar")) {
                Assert.assertEquals((Object)"myVar", (Object)var.getName());
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().executionIdIn(new String[]{"anExecutionId"});
        List result = query.list();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{task.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)query.count());
        VariableInstance var = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"taskVariable", (Object)var.getName());
        Assert.assertEquals((Object)"aCustomValue", (Object)var.getValue());
        Assert.assertEquals((Object)"string", (Object)var.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY);
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult();
        Task task3 = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.setVariableLocal(task2.getId(), "anotherTaskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{task1.getId(), task2.getId(), task3.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)query.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("taskVariable")) {
                Assert.assertEquals((Object)"taskVariable", (Object)var.getName());
                Assert.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("anotherTaskVariable")) {
                Assert.assertEquals((Object)"anotherTaskVariable", (Object)var.getName());
                Assert.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByTaskIdWithoutAnyResult() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{"aTaskId"});
        List result = query.list();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/VariableInstanceQueryTest.taskInEmbeddedSubProcess.bpmn20.xml"})
    public void testQueryByVariableScopeId() {
        List variableInstances;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String processInstanceId = task.getProcessInstanceId();
        String variableName = "foo";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(taskId, "task");
        variables.put(executionId, "execution");
        variables.put(processInstanceId, "processInstance");
        this.taskService.setVariableLocal(taskId, variableName, variables.get(taskId));
        this.runtimeService.setVariableLocal(executionId, variableName, variables.get(executionId));
        this.runtimeService.setVariableLocal(processInstanceId, variableName, variables.get(processInstanceId));
        for (String variableScopeId : variables.keySet()) {
            variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{variableScopeId}).list();
            Assert.assertEquals((long)1L, (long)variableInstances.size());
            Assert.assertEquals((Object)variableName, (Object)((VariableInstance)variableInstances.get(0)).getName());
            Assert.assertEquals(variables.get(variableScopeId), (Object)((VariableInstance)variableInstances.get(0)).getValue());
        }
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        Assert.assertEquals((long)3L, (long)variableInstances.size());
        this.taskService.removeVariableLocal(taskId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId}).list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        Assert.assertEquals((long)2L, (long)variableInstances.size());
        this.runtimeService.removeVariable(processInstanceId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{processInstanceId, taskId}).list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        Assert.assertEquals((long)1L, (long)variableInstances.size());
        this.runtimeService.removeVariable(executionId, variableName);
        variableInstances = this.runtimeService.createVariableInstanceQuery().variableScopeIdIn(new String[]{taskId, executionId, processInstanceId}).list();
        Assert.assertEquals((long)0L, (long)variableInstances.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        String activityId = this.runtimeService.getActivityInstance(processInstance.getId()).getChildActivityInstances()[0].getId();
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"aCustomValue");
        VariableInstanceQuery taskVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityId});
        VariableInstanceQuery processVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{processInstance.getId()});
        VariableInstance taskVar = (VariableInstance)taskVariablesQuery.singleResult();
        Assert.assertNotNull((Object)taskVar);
        Assert.assertEquals((long)1L, (long)taskVariablesQuery.count());
        Assert.assertEquals((Object)"string", (Object)taskVar.getTypeName());
        Assert.assertEquals((Object)"taskVariable", (Object)taskVar.getName());
        Assert.assertEquals((Object)"aCustomValue", (Object)taskVar.getValue());
        VariableInstance processVar = (VariableInstance)processVariablesQuery.singleResult();
        Assert.assertEquals((long)1L, (long)processVariablesQuery.count());
        Assert.assertEquals((Object)"string", (Object)processVar.getTypeName());
        Assert.assertEquals((Object)"stringVar", (Object)processVar.getName());
        Assert.assertEquals((Object)"test", (Object)processVar.getValue());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance procInst1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance procInst2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        HashMap<String, String> variables3 = new HashMap<String, String>();
        variables3.put("myVar", "test123");
        ProcessInstance procInst3 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables3);
        Task task1 = (Task)this.taskService.createTaskQuery().processInstanceId(procInst1.getId()).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(procInst2.getId()).singleResult();
        this.taskService.setVariableLocal(task1.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.setVariableLocal(task2.getId(), "anotherTaskVariable", (Object)"aCustomValue");
        VariableInstanceQuery processVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{procInst1.getId(), procInst2.getId(), procInst3.getId()});
        VariableInstanceQuery taskVariablesQuery = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{this.runtimeService.getActivityInstance(procInst1.getId()).getChildActivityInstances()[0].getId(), this.runtimeService.getActivityInstance(procInst2.getId()).getChildActivityInstances()[0].getId()});
        List result = processVariablesQuery.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)4L, (long)processVariablesQuery.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("myVar")) {
                Assert.assertEquals((Object)"myVar", (Object)var.getName());
                Assert.assertEquals((Object)"test123", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)var.getName());
                Assert.assertEquals((Object)"test", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
        result = taskVariablesQuery.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)taskVariablesQuery.count());
        for (VariableInstance var : result) {
            Assert.assertEquals((Object)"string", (Object)var.getTypeName());
            if (var.getName().equals("taskVariable")) {
                Assert.assertEquals((Object)"taskVariable", (Object)var.getName());
                Assert.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            if (var.getName().equals("anotherTaskVariable")) {
                Assert.assertEquals((Object)"anotherTaskVariable", (Object)var.getName());
                Assert.assertEquals((Object)"aCustomValue", (Object)var.getValue());
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + var.getName() + "' was found with value " + var.getValue()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByName_Asc() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().asc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        Assert.assertEquals((Object)"myVar", (Object)first.getName());
        Assert.assertEquals((Object)"stringVar", (Object)second.getName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByName_Desc() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableName().desc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        Assert.assertEquals((Object)"stringVar", (Object)first.getName());
        Assert.assertEquals((Object)"string", (Object)first.getTypeName());
        Assert.assertEquals((Object)"myVar", (Object)second.getName());
        Assert.assertEquals((Object)"string", (Object)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByType_Asc() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("intVar", 123);
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableType().asc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        Assert.assertEquals((Object)"intVar", (Object)first.getName());
        Assert.assertEquals((Object)"integer", (Object)first.getTypeName());
        Assert.assertEquals((Object)"myVar", (Object)second.getName());
        Assert.assertEquals((Object)"string", (Object)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByType_Desc() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("intVar", 123);
        variables.put("myVar", "test123");
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByVariableType().desc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        Assert.assertEquals((Object)"myVar", (Object)first.getName());
        Assert.assertEquals((Object)"string", (Object)first.getTypeName());
        Assert.assertEquals((Object)"intVar", (Object)second.getName());
        Assert.assertEquals((Object)"integer", (Object)second.getTypeName());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByActivityInstanceId_Asc() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        ProcessInstance procInst1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        String activityId1 = this.runtimeService.getActivityInstance(procInst1.getId()).getChildActivityInstances()[0].getId();
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        ProcessInstance procInst2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        String activityId2 = this.runtimeService.getActivityInstance(procInst2.getId()).getChildActivityInstances()[0].getId();
        int comparisonResult = activityId1.compareTo(activityId2);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByActivityInstanceId().asc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        if (comparisonResult < 0) {
            Assert.assertEquals((Object)"intVar", (Object)first.getName());
            Assert.assertEquals((Object)"integer", (Object)first.getTypeName());
            Assert.assertEquals((Object)"stringVar", (Object)second.getName());
            Assert.assertEquals((Object)"string", (Object)second.getTypeName());
        } else if (comparisonResult > 0) {
            Assert.assertEquals((Object)"stringVar", (Object)first.getName());
            Assert.assertEquals((Object)"string", (Object)first.getTypeName());
            Assert.assertEquals((Object)"intVar", (Object)second.getName());
            Assert.assertEquals((Object)"integer", (Object)second.getTypeName());
        } else {
            Assert.fail((String)("Something went wrong: both activity instances have the same id " + activityId1 + " and " + activityId2));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryOrderByActivityInstanceId_Desc() {
        HashMap<String, Integer> variables1 = new HashMap<String, Integer>();
        variables1.put("intVar", 123);
        ProcessInstance procInst1 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("stringVar", "test");
        ProcessInstance procInst2 = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables2);
        String activityId1 = this.runtimeService.getActivityInstance(procInst1.getId()).getChildActivityInstances()[0].getId();
        String activityId2 = this.runtimeService.getActivityInstance(procInst2.getId()).getChildActivityInstances()[0].getId();
        int comparisonResult = activityId1.compareTo(activityId2);
        VariableInstanceQuery query = (VariableInstanceQuery)this.runtimeService.createVariableInstanceQuery().orderByActivityInstanceId().desc();
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        VariableInstance first = (VariableInstance)result.get(0);
        VariableInstance second = (VariableInstance)result.get(1);
        if (comparisonResult < 0) {
            Assert.assertEquals((Object)"stringVar", (Object)first.getName());
            Assert.assertEquals((Object)"string", (Object)first.getTypeName());
            Assert.assertEquals((Object)"intVar", (Object)second.getName());
            Assert.assertEquals((Object)"integer", (Object)second.getTypeName());
        } else if (comparisonResult > 0) {
            Assert.assertEquals((Object)"intVar", (Object)first.getName());
            Assert.assertEquals((Object)"integer", (Object)first.getTypeName());
            Assert.assertEquals((Object)"stringVar", (Object)second.getName());
            Assert.assertEquals((Object)"string", (Object)second.getTypeName());
        } else {
            Assert.fail((String)("Something went wrong: both activity instances have the same id " + activityId1 + " and " + activityId2));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testGetValueOfSerializableVar() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        HashMap<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();
        variables.put("serializableVar", serializable);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()});
        List result = query.list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance instance = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"serializableVar", (Object)instance.getName());
        Assert.assertNotNull((Object)instance.getValue());
        Assert.assertEquals(serializable, (Object)instance.getValue());
        Assert.assertEquals((Object)ValueType.OBJECT.getName(), (Object)instance.getTypeName());
    }

    @Test
    @Deployment
    public void testSubProcessVariablesWithParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        ActivityInstance[] subprocessInstances = tree.getActivityInstances("SubProcess_1");
        Assert.assertEquals((long)5L, (long)subprocessInstances.length);
        String activityInstanceId1 = subprocessInstances[0].getId();
        VariableInstanceQuery query1 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId1});
        String activityInstanceId2 = subprocessInstances[1].getId();
        VariableInstanceQuery query2 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId2});
        String activityInstanceId3 = subprocessInstances[2].getId();
        VariableInstanceQuery query3 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId3});
        String activityInstanceId4 = subprocessInstances[3].getId();
        VariableInstanceQuery query4 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId4});
        String activityInstanceId5 = subprocessInstances[4].getId();
        VariableInstanceQuery query5 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{activityInstanceId5});
        this.checkVariables(query1.list());
        this.checkVariables(query2.list());
        this.checkVariables(query3.list());
        this.checkVariables(query4.list());
        this.checkVariables(query5.list());
    }

    private void checkVariables(List<VariableInstance> variableInstances) {
        Assert.assertFalse((boolean)variableInstances.isEmpty());
        for (VariableInstance instance : variableInstances) {
            if (instance.getName().equals("nrOfInstances")) {
                Assert.assertEquals((Object)"nrOfInstances", (Object)instance.getName());
                Assert.assertEquals((Object)"integer", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nrOfCompletedInstances")) {
                Assert.assertEquals((Object)"nrOfCompletedInstances", (Object)instance.getName());
                Assert.assertEquals((Object)"integer", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nrOfActiveInstances")) {
                Assert.assertEquals((Object)"nrOfActiveInstances", (Object)instance.getName());
                Assert.assertEquals((Object)"integer", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("loopCounter")) {
                Assert.assertEquals((Object)"loopCounter", (Object)instance.getName());
                Assert.assertEquals((Object)"integer", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("nullVar")) {
                Assert.assertEquals((Object)"nullVar", (Object)instance.getName());
                Assert.assertEquals((Object)"null", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("integerVar")) {
                Assert.assertEquals((Object)"integerVar", (Object)instance.getName());
                Assert.assertEquals((Object)"integer", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("dateVar")) {
                Assert.assertEquals((Object)"dateVar", (Object)instance.getName());
                Assert.assertEquals((Object)"date", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("stringVar")) {
                Assert.assertEquals((Object)"stringVar", (Object)instance.getName());
                Assert.assertEquals((Object)"string", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("shortVar")) {
                Assert.assertEquals((Object)"shortVar", (Object)instance.getName());
                Assert.assertEquals((Object)"short", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("longVar")) {
                Assert.assertEquals((Object)"longVar", (Object)instance.getName());
                Assert.assertEquals((Object)"long", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("byteVar")) {
                Assert.assertEquals((Object)"bytes", (Object)instance.getTypeName());
                continue;
            }
            if (instance.getName().equals("serializableVar")) {
                Assert.assertEquals((Object)"serializableVar", (Object)instance.getName());
                try {
                    instance.getValue();
                }
                catch (NullPointerException nullPointerException) {}
                continue;
            }
            Assert.fail((String)("An unexpected variable '" + instance.getName() + "' was found with value " + instance.getValue()));
        }
    }

    @Test
    @Deployment
    public void testSubProcessVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess", processVariables);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertNotNull((Object)tree);
        Assert.assertEquals((long)1L, (long)tree.getChildActivityInstances().length);
        VariableInstanceQuery query1 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{tree.getId()});
        VariableInstance processVariable = (VariableInstance)query1.singleResult();
        Assert.assertNotNull((Object)processVariable);
        Assert.assertEquals((Object)"processVariable", (Object)processVariable.getName());
        Assert.assertEquals((Object)"aProcessVariable", (Object)processVariable.getValue());
        ActivityInstance subProcessActivityInstance = tree.getActivityInstances("SubProcess_1")[0];
        VariableInstanceQuery query2 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{subProcessActivityInstance.getId()});
        this.checkVariables(query2.list());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVariable", (Object)"taskVariableValue");
        ActivityInstance taskActivityInstance = subProcessActivityInstance.getChildActivityInstances()[0];
        VariableInstanceQuery query3 = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{taskActivityInstance.getId()});
        VariableInstance taskVariable = (VariableInstance)query3.singleResult();
        Assert.assertNotNull((Object)taskVariable);
        Assert.assertEquals((Object)"taskVariable", (Object)taskVariable.getName());
        Assert.assertEquals((Object)"taskVariableValue", (Object)taskVariable.getValue());
    }

    @Test
    @Deployment
    public void testParallelGatewayVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGatewayProcess", processVariables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(execution.getId(), "aLocalVariable", (Object)"aLocalValue");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)2L, (long)tree.getChildActivityInstances().length);
        ActivityInstance task1Instance = tree.getActivityInstances("task1")[0];
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").activityInstanceIdIn(new String[]{task1Instance.getId()});
        VariableInstance localVariable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)"aLocalVariable", (Object)localVariable.getName());
        Assert.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().executionId(execution.getId()).singleResult();
        this.taskService.complete(task.getId());
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)2L, (long)tree.getChildActivityInstances().length);
        ActivityInstance task3Instance = tree.getActivityInstances("task3")[0];
        query = this.runtimeService.createVariableInstanceQuery().variableName("aLocalVariable").activityInstanceIdIn(new String[]{task3Instance.getId()});
        localVariable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)"aLocalVariable", (Object)localVariable.getName());
        Assert.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
    }

    @Deployment
    @Test
    public void testSimpleSubProcessVariables() {
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("processVariable", "aProcessVariable");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processWithSubProcess", processVariables);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("UserTask_1").singleResult();
        this.runtimeService.setVariableLocal(task.getExecutionId(), "aLocalVariable", (Object)"aLocalValue");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)tree.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = tree.getActivityInstances("SubProcess_1")[0];
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{subProcessInstance.getId()});
        VariableInstance localVariable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)"aLocalVariable", (Object)localVariable.getName());
        Assert.assertEquals((Object)"aLocalValue", (Object)localVariable.getValue());
        query = this.runtimeService.createVariableInstanceQuery().activityInstanceIdIn(new String[]{processInstance.getId()});
        VariableInstance globalVariable = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)localVariable);
        Assert.assertEquals((Object)"processVariable", (Object)globalVariable.getName());
        Assert.assertEquals((Object)"aProcessVariable", (Object)globalVariable.getValue());
        this.taskService.complete(task.getId());
    }

    @Test
    public void testDisableBinaryFetching() {
        byte[] binaryContent = "some binary content".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("binaryVariable", binaryContent);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        VariableInstance result = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)result.getValue());
        query = this.runtimeService.createVariableInstanceQuery().disableBinaryFetching();
        result = (VariableInstance)query.singleResult();
        Assert.assertNull((Object)result.getValue());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testDisableBinaryFetchingForFileValues() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        VariableInstance fileVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance.getValue());
        fileVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().disableBinaryFetching().singleResult();
        Assert.assertNotNull((Object)fileVariableInstance);
        Assert.assertEquals((Object)"fileVar", (Object)fileVariableInstance.getName());
        Assert.assertNull((Object)fileVariableInstance.getValue());
        FileValue typedValue = (FileValue)fileVariableInstance.getTypedValue();
        Assert.assertNull((Object)typedValue.getValue());
        Assert.assertEquals((Object)ValueType.FILE, (Object)typedValue.getType());
        Assert.assertEquals((Object)fileName, (Object)typedValue.getFilename());
        Assert.assertEquals((Object)encoding, (Object)typedValue.getEncoding());
        Assert.assertEquals((Object)mimeType, (Object)typedValue.getMimeType());
    }

    @Test
    public void testDisableCustomObjectDeserialization() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().disableCustomObjectDeserialization();
        List results = query.list();
        Assert.assertEquals((long)2L, (long)results.size());
        for (VariableInstance variableInstance : results) {
            Assert.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            Assert.assertNotNull((Object)typedValue);
            Assert.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.testRule.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            Assert.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSerializableErrorMessage() {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariablesLocal(task.getId(), variables);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List results = query.list();
        Assert.assertEquals((long)2L, (long)results.size());
        for (VariableInstance variableInstance : results) {
            if (variableInstance.getName().equals("customSerializable")) {
                Assert.assertNotNull((Object)variableInstance.getValue());
                Assert.assertTrue((boolean)(variableInstance.getValue() instanceof CustomSerializable));
            }
            if (!variableInstance.getName().equals("failingSerializable")) continue;
            Assert.assertNull((Object)variableInstance.getValue());
            Assert.assertNotNull((Object)variableInstance.getErrorMessage());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseExecutionIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aVariableName", (Object)result.getName());
        Assert.assertEquals((Object)"abc", (Object)result.getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseExecutionId());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseInstanceId());
        Assert.assertNull((Object)result.getExecutionId());
        Assert.assertNull((Object)result.getProcessInstanceId());
        Assert.assertNull((Object)result.getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseExecutionIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseInstanceIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aVariableName", (Object)result.getName());
        Assert.assertEquals((Object)"abc", (Object)result.getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseExecutionId());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseInstanceId());
        Assert.assertNull((Object)result.getExecutionId());
        Assert.assertNull((Object)result.getProcessInstanceId());
        Assert.assertNull((Object)result.getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.caseInstanceIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityInstanceId() {
        CaseInstance instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{instance.getId()});
        VariableInstance result = (VariableInstance)query.singleResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aVariableName", (Object)result.getName());
        Assert.assertEquals((Object)"abc", (Object)result.getValue());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseExecutionId());
        Assert.assertEquals((Object)instance.getId(), (Object)result.getCaseInstanceId());
        Assert.assertNull((Object)result.getExecutionId());
        Assert.assertNull((Object)result.getProcessInstanceId());
        Assert.assertNull((Object)result.getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseActivityInstanceIds() {
        CaseInstance instance1 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"abc").create();
        CaseInstance instance2 = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("anotherVariableName", (Object)"xyz").create();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{instance1.getId(), instance2.getId()}).orderByVariableName().asc();
        List result = query.list();
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"abc", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"xyz", (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment
    @Test
    public void testSequentialMultiInstanceSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        VariableInstance nrOfInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfInstances").singleResult();
        VariableInstance nrOfActiveInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfActiveInstances").singleResult();
        VariableInstance nrOfCompletedInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfCompletedInstances").singleResult();
        VariableInstance loopCounter = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("loopCounter").singleResult();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfInstances.getActivityInstanceId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfActiveInstances.getActivityInstanceId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfCompletedInstances.getActivityInstanceId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)loopCounter.getActivityInstanceId());
    }

    @Deployment
    @Test
    public void testParallelMultiInstanceSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        VariableInstance nrOfInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfInstances").singleResult();
        VariableInstance nrOfActiveInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfActiveInstances").singleResult();
        VariableInstance nrOfCompletedInstances = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("nrOfCompletedInstances").singleResult();
        List loopCounters = this.runtimeService.createVariableInstanceQuery().variableName("loopCounter").list();
        ActivityInstance tree = this.runtimeService.getActivityInstance(instance.getId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfInstances.getActivityInstanceId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfActiveInstances.getActivityInstanceId());
        Assert.assertEquals((Object)tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId(), (Object)nrOfCompletedInstances.getActivityInstanceId());
        HashSet<String> loopCounterActivityInstanceIds = new HashSet<String>();
        for (VariableInstance loopCounter : loopCounters) {
            loopCounterActivityInstanceIds.add(loopCounter.getActivityInstanceId());
        }
        Assert.assertEquals((long)4L, (long)loopCounterActivityInstanceIds.size());
        for (ActivityInstance subProcessInstance : tree.getActivityInstances("miSubProcess")) {
            Assert.assertTrue((boolean)loopCounterActivityInstanceIds.contains(subProcessInstance.getId()));
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testVariablesProcessDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)variable.getProcessDefinitionId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldGetBatchId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY).getId();
        List<String> processInstances = Collections.singletonList(processInstanceId);
        VariableMap variables = Variables.putValue((String)"foo", (Object)"bar");
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Java6Assertions.assertThat((String)variableInstance.getBatchId()).isEqualTo((Object)batch.getId());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryForBatchId() {
        VariableMap variables = Variables.putValue((String)"foo", (Object)"bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, (Map)variables).getId();
        List<String> processInstances = Collections.singletonList(processInstanceId);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)variables);
        VariableInstanceQuery variableInstanceQuery = this.runtimeService.createVariableInstanceQuery();
        Java6Assertions.assertThat((List)variableInstanceQuery.list()).extracting(new String[]{"name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", batch.getId()}), Tuple.tuple((Object[])new Object[]{"foo", "bar", null})});
        variableInstanceQuery = variableInstanceQuery.batchIdIn(new String[]{batch.getId()});
        Java6Assertions.assertThat((List)variableInstanceQuery.list()).extracting(new String[]{"name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", batch.getId()})});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryForBatchIds() {
        VariableMap variables = Variables.putValue((String)"foo", (Object)"bar");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, (Map)variables).getId();
        List<String> processInstances = Collections.singletonList(processInstanceId);
        Batch batchOne = this.runtimeService.setVariablesAsync(processInstances, (Map)variables);
        Batch batchTwo = this.runtimeService.setVariablesAsync(processInstances, (Map)variables);
        Batch batchThree = this.runtimeService.setVariablesAsync(processInstances, (Map)variables);
        VariableInstanceQuery variableInstanceQuery = this.runtimeService.createVariableInstanceQuery();
        Java6Assertions.assertThat((List)variableInstanceQuery.list()).extracting(new String[]{"name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", batchOne.getId()}), Tuple.tuple((Object[])new Object[]{"foo", "bar", batchTwo.getId()}), Tuple.tuple((Object[])new Object[]{"foo", "bar", batchThree.getId()}), Tuple.tuple((Object[])new Object[]{"foo", "bar", null})});
        variableInstanceQuery = variableInstanceQuery.batchIdIn(new String[]{batchOne.getId(), batchTwo.getId()});
        Java6Assertions.assertThat((List)variableInstanceQuery.list()).extracting(new String[]{"name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"foo", "bar", batchOne.getId()}), Tuple.tuple((Object[])new Object[]{"foo", "bar", batchTwo.getId()})});
        this.managementService.deleteBatch(batchOne.getId(), true);
        this.managementService.deleteBatch(batchTwo.getId(), true);
        this.managementService.deleteBatch(batchThree.getId(), true);
    }
}

