/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Map;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.test.api.runtime.util.TestVariableScope;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableScopeTest {
    private static final String VAR_NAME = "foo";
    private static final String VAR_VALUE_STRING = "bar";
    private VariableScope variableScope;

    @Before
    public void setUp() {
        this.variableScope = new TestVariableScope();
        this.variableScope.setVariable(VAR_NAME, (Object)VAR_VALUE_STRING);
    }

    @Test
    public void testGetVariables() {
        Map variables = this.variableScope.getVariables();
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((Object)VAR_VALUE_STRING, variables.get(VAR_NAME));
    }

    @Test
    public void testGetVariablesTyped() {
        VariableMap variables = this.variableScope.getVariablesTyped();
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((Object)VAR_VALUE_STRING, (Object)variables.get((Object)VAR_NAME));
        Assert.assertEquals((Object)variables, (Object)this.variableScope.getVariablesTyped(true));
    }

    @Test
    public void testGetVariablesLocal() {
        Map variables = this.variableScope.getVariablesLocal();
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((Object)VAR_VALUE_STRING, variables.get(VAR_NAME));
    }

    @Test
    public void testGetVariablesLocalTyped() {
        VariableMap variables = this.variableScope.getVariablesLocalTyped();
        Assert.assertNotNull((Object)variables);
        Assert.assertEquals((Object)VAR_VALUE_STRING, variables.get(VAR_NAME));
        Assert.assertEquals((Object)variables, (Object)this.variableScope.getVariablesLocalTyped(true));
    }
}

