/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.ConditionalEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MessageEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.SignalEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.TimerEventFactory;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MigrateEventSubProcessAndTriggerTest {
    @Parameterized.Parameter
    public BpmnEventFactory eventFactory;
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new TimerEventFactory()}, {new MessageEventFactory()}, {new SignalEventFactory()}, {new ConditionalEventFactory()});
    }

    @Before
    public void setUp() {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Test
    public void testMigrateEventSubprocessSignalTrigger() {
        BpmnModelInstance processModel = ProcessModels.ONE_TASK_PROCESS.clone();
        MigratingBpmnEventTrigger eventTrigger = this.eventFactory.addEventSubProcess(this.rule.getProcessEngine(), processModel, "Process", "eventSubProcess", "eventSubProcessStart");
        ModifiableBpmnModelInstance.wrap(processModel).startEventBuilder("eventSubProcessStart").userTask("eventSubProcessTask").endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(processModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(processModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        eventTrigger.assertEventTriggerMigrated(this.testHelper, "eventSubProcessStart");
        eventTrigger.trigger(processInstance.getId());
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask("eventSubProcessTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

