/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.migration.MigrationPlanValidationException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.builder.CompensateEventDefinitionBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationCompensationAddSubProcessTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCase1CannotTriggerCompensationInNewScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((CompensateEventDefinitionBuilder)ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL).endEventBuilder("subProcessEnd").compensateEventDefinition().waitForCompletion(true)).compensateEventDefinitionDone().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").activity("compensationHandler").done());
    }

    @Test
    public void testCase1AssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask2").scope().up().child("subProcess").scope().eventScope().done());
    }

    @Test
    public void testCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCase2AssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("subProcess").scope().eventScope().done());
    }

    @Test
    public void testCase2AssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").activity("compensationHandler").done());
    }

    @Test
    public void testNoListenersCalled() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).activityBuilder("subProcess").camundaExecutionListenerExpression("start", "${execution.setVariable('foo', 'bar')}").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
    }

    @Ignore(value="CAM-6035")
    @Test
    public void testNoInputMappingExecuted() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).activityBuilder("subProcess").camundaInputParameter("foo", "bar").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
    }

    @Test
    public void testVariablesInParentEventScopeStillAccessible() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.DOUBLE_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "outerSubProcess").mapActivities("compensationBoundary", "compensationBoundary").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Execution subProcessExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("userTask1").singleResult();
        this.rule.getRuntimeService().setVariableLocal(subProcessExecution.getId(), "foo", (Object)"bar");
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeAnyTask("userTask2");
        Task compensationTask = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        Assert.assertEquals((Object)"bar", (Object)this.rule.getTaskService().getVariable(compensationTask.getId(), "foo"));
    }

    @Test
    public void testCannotAddScopeOnTopOfEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(CompensationModels.DOUBLE_SUBPROCESS_MODEL).addSubProcessTo("innerSubProcess").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").compensateEventDefinition().compensateEventDefinitionDone().endEvent().done());
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "outerSubProcess").mapActivities("eventSubProcessStart", "eventSubProcessStart").mapActivities("compensationBoundary", "compensationBoundary").mapActivities("userTask2", "userTask2").build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures("eventSubProcessStart", "The source activity's event scope (subProcess) must be mapped to the target activity's event scope (innerSubProcess)");
        }
    }
}

