/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.EventBasedGatewayModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationEventBasedGatewayTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateGatewayExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("eventBasedGateway").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("eventBasedGateway")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("eventBasedGateway", this.testHelper.getSingleActivityInstanceBeforeMigration("eventBasedGateway").getId()).done());
    }

    @Test
    public void testMigrateGatewayWithTimerEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertIntermediateTimerJobRemoved("timerCatch");
        this.testHelper.assertIntermediateTimerJobCreated("timerCatch");
        Job timerJob = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(timerJob.getId());
        this.testHelper.completeTask("afterTimerCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithMessageEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("messageCatch", "Message");
        this.testHelper.assertEventSubscriptionCreated("messageCatch", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("afterMessageCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithSignalEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("signalCatch", "Signal");
        this.testHelper.assertEventSubscriptionCreated("signalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("afterSignalCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithTimerEventMapEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertIntermediateTimerJobMigrated("timerCatch", "timerCatch");
        Job timerJob = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(timerJob.getId());
        this.testHelper.completeTask("afterTimerCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithMessageEventMapEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("messageCatch", "messageCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("messageCatch", "messageCatch", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("afterMessageCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithSignalEventMapEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("signalCatch", "signalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("afterSignalCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayAddTimerEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("newTimerCatch").timerWithDuration("PT50M")).userTask("afterNewTimerCatch").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertIntermediateTimerJobCreated("newTimerCatch");
        this.testHelper.assertIntermediateTimerJobMigrated("timerCatch", "timerCatch");
        Job newTimerJob = (Job)this.rule.getManagementService().createJobQuery().activityId("newTimerCatch").singleResult();
        this.rule.getManagementService().executeJob(newTimerJob.getId());
        this.testHelper.completeTask("afterNewTimerCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayAddMessageEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("newMessageCatch").message("newMessage")).userTask("afterNewMessageCatch").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("messageCatch", "messageCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("newMessageCatch", "newMessage");
        this.testHelper.assertEventSubscriptionMigrated("messageCatch", "messageCatch", "Message");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask("afterNewMessageCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayAddSignalEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("newSignalCatch").signal("newSignal")).userTask("afterNewSignalCatch").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("signalCatch", "signalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("newSignalCatch", "newSignal");
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask("afterNewSignalCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayRemoveTimerEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("oldTimerCatch").timerWithDuration("PT50M")).endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("timerCatch", "timerCatch").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertIntermediateTimerJobRemoved("oldTimerCatch");
        this.testHelper.assertIntermediateTimerJobMigrated("timerCatch", "timerCatch");
    }

    @Test
    public void testMigrateGatewayRemoveMessageEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("oldMessageCatch").message("oldMessage")).endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("messageCatch", "messageCatch").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("oldMessageCatch", "oldMessage");
        this.testHelper.assertEventSubscriptionMigrated("messageCatch", "messageCatch", "Message");
    }

    @Test
    public void testMigrateGatewayRemoveSignalEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((IntermediateCatchEventBuilder)ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS).flowNodeBuilder("eventBasedGateway").intermediateCatchEvent("oldSignalCatch").signal("oldSignal")).endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("signalCatch", "signalCatch").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("oldSignalCatch", "oldSignal");
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "signalCatch", "Signal");
    }

    @Test
    public void testMigrateGatewayWithTimerEventChangeId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS).changeElementId("timerCatch", "newTimerCatch"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("timerCatch", "newTimerCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertIntermediateTimerJobMigrated("timerCatch", "newTimerCatch");
        Job timerJob = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(timerJob.getId());
        this.testHelper.completeTask("afterTimerCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithMessageEventChangeId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.MESSAGE_EVENT_BASED_GW_PROCESS).changeElementId("messageCatch", "newMessageCatch"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("messageCatch", "newMessageCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("messageCatch", "newMessageCatch", "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        this.testHelper.completeTask("afterMessageCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithSignalEventChangeId() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS).changeElementId("signalCatch", "newSignalCatch"));
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("signalCatch", "newSignalCatch").build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("signalCatch", "newSignalCatch", "Signal");
        this.rule.getRuntimeService().signalEventReceived("Signal");
        this.testHelper.completeTask("afterSignalCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayWithIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").mapActivities("timerCatch", "timerCatch").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Job timerJob = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(timerJob.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertIntermediateTimerJobMigrated("timerCatch", "timerCatch");
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)jobAfterMigration.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"timerCatch", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask("afterTimerCatch");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateGatewayRemoveIncidentOnMigration() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventBasedGateway", "eventBasedGateway").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Job timerJob = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(timerJob.getId(), 0);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createIncidentQuery().count());
    }
}

