/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import java.util.HashMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.management.ActivityStatistics;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.migration.MigrationPlanValidationException;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ClockTestUtil;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.MigrationPlanValidationReportAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationEventSubProcessTest {
    public static final String SIGNAL_NAME = "Signal";
    protected static final String EVENT_SUB_PROCESS_START_ID = "eventSubProcessStart";
    protected static final String EVENT_SUB_PROCESS_TASK_ID = "eventSubProcessTask";
    protected static final String USER_TASK_ID = "userTask";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateActiveEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity(EVENT_SUB_PROCESS_TASK_ID)).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities(EVENT_SUB_PROCESS_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child(EVENT_SUB_PROCESS_TASK_ID).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("eventSubProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcess").getId()).activity(EVENT_SUB_PROCESS_TASK_ID, this.testHelper.getSingleActivityInstanceBeforeMigration(EVENT_SUB_PROCESS_TASK_ID).getId()).done());
        this.testHelper.assertEventSubscriptionRemoved(EVENT_SUB_PROCESS_START_ID, "Message");
        this.testHelper.assertEventSubscriptionCreated(EVENT_SUB_PROCESS_START_ID, "Message");
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEventSubProcessToEmbeddedSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity(EVENT_SUB_PROCESS_TASK_ID)).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "subProcess").mapActivities(EVENT_SUB_PROCESS_TASK_ID, USER_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child(USER_TASK_ID).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("eventSubProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("eventSubProcess").getId()).activity(USER_TASK_ID, this.testHelper.getSingleActivityInstanceBeforeMigration(EVENT_SUB_PROCESS_TASK_ID).getId()).done());
        this.testHelper.assertEventSubscriptionRemoved(EVENT_SUB_PROCESS_START_ID, "Message");
        Assert.assertEquals((long)0L, (long)this.testHelper.snapshotAfterMigration.getEventSubscriptions().size());
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEmbeddedSubProcessToEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "eventSubProcess").mapActivities(USER_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(processInstance.getId()).child(EVENT_SUB_PROCESS_TASK_ID).scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess", this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess").getId()).activity(EVENT_SUB_PROCESS_TASK_ID, this.testHelper.getSingleActivityInstanceBeforeMigration(USER_TASK_ID).getId()).done());
        this.testHelper.assertEventSubscriptionCreated(EVENT_SUB_PROCESS_START_ID, "Message");
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveErrorEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity(EVENT_SUB_PROCESS_TASK_ID)).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities(EVENT_SUB_PROCESS_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveCompensationEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity(EVENT_SUB_PROCESS_TASK_ID)).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities(EVENT_SUB_PROCESS_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateActiveEscalationEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity(EVENT_SUB_PROCESS_TASK_ID)).execute();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "eventSubProcess").mapActivities(EVENT_SUB_PROCESS_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateTaskAddEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, EVENT_SUB_PROCESS_TASK_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(EVENT_SUB_PROCESS_TASK_ID).scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("eventSubProcess").activity(EVENT_SUB_PROCESS_TASK_ID, this.testHelper.getSingleActivityInstanceBeforeMigration(USER_TASK_ID).getId()).done());
        this.testHelper.assertEventSubscriptionCreated(EVENT_SUB_PROCESS_START_ID, "Message");
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessMessageKeepTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID, "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessTimerKeepTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertJobMigrated(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID, "timer-start-event-subprocess");
        Job timerJob = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(timerJob.getId());
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubprocessSignalKeepTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID, SIGNAL_NAME);
        this.rule.getRuntimeService().signalEventReceived(SIGNAL_NAME);
        Assert.assertEquals((long)1L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateConditionalBoundaryEventKeepTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.CONDITIONAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.CONDITIONAL_EVENT_SUBPROCESS_PROCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build()).isInstanceOf(MigrationPlanValidationException.class)).hasMessageContaining("Conditional event has to migrate with update event trigger.");
    }

    @Test
    public void testMigrateEventSubprocessChangeStartEventType() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        try {
            this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
            Assert.fail((String)"exception expected");
        }
        catch (MigrationPlanValidationException e) {
            MigrationPlanValidationReportAssert.assertThat(e.getValidationReport()).hasInstructionFailures(EVENT_SUB_PROCESS_START_ID, "Events are not of the same type (signalStartEvent != startTimerEvent)");
        }
    }

    @Test
    public void testMigrateEventSubprocessTimerIncident() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job timerTriggerJob = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        this.rule.getManagementService().setJobRetries(timerTriggerJob.getId(), 0);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)timerTriggerJob.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)EVENT_SUB_PROCESS_START_ID, (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        this.rule.getManagementService().executeJob(timerTriggerJob.getId());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateNonInterruptingEventSubprocessMessageTrigger() {
        BpmnModelInstance nonInterruptingModel = ((StartEventBuilder)ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).startEventBuilder(EVENT_SUB_PROCESS_START_ID).interrupting(false)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(nonInterruptingModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(nonInterruptingModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID, "Message");
        this.rule.getRuntimeService().correlateMessage("Message");
        Assert.assertEquals((long)2L, (long)this.rule.getTaskService().createTaskQuery().count());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testUpdateEventMessage() {
        BpmnModelInstance sourceProcess = EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).renameMessage("Message", "newMessage");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, "Message", EVENT_SUB_PROCESS_START_ID, "newMessage");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventSignal() {
        BpmnModelInstance sourceProcess = EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS).renameSignal(SIGNAL_NAME, "newSignal");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, SIGNAL_NAME, EVENT_SUB_PROCESS_START_ID, "newSignal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventTimer() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        BpmnModelInstance sourceProcess = EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ((StartEventBuilder)ModifiableBpmnModelInstance.modify(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).removeChildren(EVENT_SUB_PROCESS_START_ID).startEventBuilder(EVENT_SUB_PROCESS_START_ID).timerWithDuration("PT50M")).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusMinutes(50).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), EVENT_SUB_PROCESS_START_ID, newDueDate);
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventMessageWithExpression() {
        String newMessageNameWithExpression = "newMessage-${var}";
        BpmnModelInstance sourceProcess = EventSubProcessModels.MESSAGE_INTERMEDIATE_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_INTERMEDIATE_EVENT_SUBPROCESS_PROCESS).renameMessage("Message", newMessageNameWithExpression);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities("eventSubProcess", "eventSubProcess").mapActivities("catchMessage", "catchMessage").updateEventTrigger().build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("var", "foo");
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan, variables);
        String resolvedMessageName = "newMessage-foo";
        this.testHelper.assertEventSubscriptionMigrated("catchMessage", "Message", "catchMessage", resolvedMessageName);
        this.rule.getRuntimeService().correlateMessage(resolvedMessageName);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventSignalWithExpression() {
        String newSignalNameWithExpression = "newMessage-${var}";
        BpmnModelInstance sourceProcess = EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS).renameSignal(SIGNAL_NAME, newSignalNameWithExpression);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).updateEventTrigger().build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("var", "foo");
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan, variables);
        String resolvedsignalName = "newMessage-foo";
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, SIGNAL_NAME, EVENT_SUB_PROCESS_START_ID, resolvedsignalName);
        this.rule.getRuntimeService().signalEventReceived(resolvedsignalName);
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateConditionalEventExpression() {
        BpmnModelInstance sourceProcess = EventSubProcessModels.FALSE_CONDITIONAL_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.CONDITIONAL_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).mapActivities(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID).updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated(EVENT_SUB_PROCESS_START_ID, EVENT_SUB_PROCESS_START_ID, null);
        this.testHelper.setAnyVariable(this.testHelper.snapshotAfterMigration.getProcessInstanceId());
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void shouldRemainActiveAfterUserTaskBecomesNoneScope() {
        BpmnModelInstance sourceModel = ((BoundaryEventBuilder)((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent(EVENT_SUB_PROCESS_START_ID).message("Message")).userTask(EVENT_SUB_PROCESS_TASK_ID).boundaryEvent().condition("${true == false}")).endEvent().endEvent().subProcessDone().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getRuntimeService().correlateMessage("Message");
        ActivityStatistics activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(sourceProcessDefinition.getId()).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)EVENT_SUB_PROCESS_TASK_ID);
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(targetProcessDefinition.getId()).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)EVENT_SUB_PROCESS_TASK_ID);
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
    }

    @Test
    public void shouldRemainActiveAfterUserTaskBecomesScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        BpmnModelInstance targetModel = ((BoundaryEventBuilder)((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent(EVENT_SUB_PROCESS_START_ID).message("Message")).userTask(EVENT_SUB_PROCESS_TASK_ID).boundaryEvent().condition("${true == false}")).endEvent().endEvent().subProcessDone().done();
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getRuntimeService().correlateMessage("Message");
        ActivityStatistics activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(sourceProcessDefinition.getId()).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)EVENT_SUB_PROCESS_TASK_ID);
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        activityStatistics = (ActivityStatistics)this.rule.getManagementService().createActivityStatisticsQuery(targetProcessDefinition.getId()).singleResult();
        Assertions.assertThat((String)activityStatistics.getId()).isEqualTo((Object)EVENT_SUB_PROCESS_TASK_ID);
        Assertions.assertThat((int)activityStatistics.getInstances()).isEqualTo(1);
    }
}

