/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Arrays;
import java.util.Collection;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MigrationNestedEventSubProcessTest {
    protected static final String USER_TASK_ID = "userTask";
    protected static final String EVENT_SUB_PROCESS_START_ID = "eventSubProcessStart";
    protected static final String EVENT_SUB_PROCESS_TASK_ID = "eventSubProcessTask";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    @Parameterized.Parameter
    public MigrationEventSubProcessTestConfiguration configuration;
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new MigrationEventSubProcessTestConfiguration(){

            @Override
            public BpmnModelInstance getSourceProcess() {
                return EventSubProcessModels.NESTED_EVENT_SUB_PROCESS_PROCESS;
            }

            @Override
            public String getEventName() {
                return "Message";
            }

            @Override
            public void triggerEventSubProcess(MigrationTestRule testHelper) {
                testHelper.correlateMessage("Message");
            }

            public String toString() {
                return "MigrateMessageEventSubProcess";
            }
        }}, {new MigrationEventSubProcessTestConfiguration(){

            @Override
            public BpmnModelInstance getSourceProcess() {
                return ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID).signal("Signal")).userTask(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_TASK_ID).endEvent().subProcessDone().done();
            }

            @Override
            public String getEventName() {
                return "Signal";
            }

            @Override
            public void triggerEventSubProcess(MigrationTestRule testHelper) {
                testHelper.sendSignal("Signal");
            }

            public String toString() {
                return "MigrateSignalEventSubProcess";
            }
        }}, {new MigrationEventSubProcessTestConfiguration(){

            @Override
            public BpmnModelInstance getSourceProcess() {
                return ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID).timerWithDate(MigrationNestedEventSubProcessTest.TIMER_DATE)).userTask(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_TASK_ID).endEvent().subProcessDone().done();
            }

            @Override
            public void assertMigration(MigrationTestRule testHelper) {
                testHelper.assertEventSubProcessTimerJobRemoved(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID);
                testHelper.assertEventSubProcessTimerJobCreated(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID);
            }

            @Override
            public String getEventName() {
                return null;
            }

            @Override
            public void triggerEventSubProcess(MigrationTestRule testHelper) {
                testHelper.triggerTimer();
            }

            public String toString() {
                return "MigrateTimerEventSubProcess";
            }
        }}, {new MigrationEventSubProcessTestConfiguration(){

            @Override
            public BpmnModelInstance getSourceProcess() {
                return ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID).condition("${any=='any'}")).userTask(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_TASK_ID).endEvent().subProcessDone().done();
            }

            @Override
            public String getEventName() {
                return null;
            }

            @Override
            public void triggerEventSubProcess(MigrationTestRule testHelper) {
                testHelper.setAnyVariable(testHelper.snapshotAfterMigration.getProcessInstanceId());
            }

            public String toString() {
                return "MigrateConditionalEventSubProcess";
            }
        }});
    }

    @Test
    public void testMapUserTaskSiblingOfEventSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(this.configuration.getSourceProcess());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(this.configuration.getSourceProcess());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(USER_TASK_ID).scope().done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess").activity(USER_TASK_ID, this.testHelper.getSingleActivityInstanceBeforeMigration(USER_TASK_ID).getId()).done());
        this.configuration.assertMigration(this.testHelper);
        this.testHelper.completeTask(USER_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMapUserTaskSiblingOfEventSubProcessAndTriggerEvent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(this.configuration.getSourceProcess());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(this.configuration.getSourceProcess());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities(USER_TASK_ID, USER_TASK_ID).build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.configuration.triggerEventSubProcess(this.testHelper);
        this.testHelper.completeTask(EVENT_SUB_PROCESS_TASK_ID);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    protected static abstract class MigrationEventSubProcessTestConfiguration {
        protected MigrationEventSubProcessTestConfiguration() {
        }

        public abstract BpmnModelInstance getSourceProcess();

        public abstract String getEventName();

        public void assertMigration(MigrationTestRule testHelper) {
            testHelper.assertEventSubscriptionRemoved(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID, this.getEventName());
            testHelper.assertEventSubscriptionCreated(MigrationNestedEventSubProcessTest.EVENT_SUB_PROCESS_START_ID, this.getEventName());
        }

        public abstract void triggerEventSubProcess(MigrationTestRule var1);
    }
}

