/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationTimerBoundryEventTest {
    private static final String DUE_DATE_IN_THE_PAST = "2018-02-11T12:13:14Z";
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.managementService = this.rule.getManagementService();
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @After
    public void cleanUpJobs() {
        List jobs = this.managementService.createJobQuery().list();
        if (!jobs.isEmpty()) {
            for (Job job : jobs) {
                this.managementService.deleteJob(job.getId());
            }
        }
    }

    @Test
    public void testMigrationNonInterruptingTimerEvent() {
        BpmnModelInstance model = this.createModel(false, DUE_DATE_IN_THE_PAST);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
    }

    @Test
    public void testMigrationInterruptingTimerEvent() {
        BpmnModelInstance model = this.createModel(true, DUE_DATE_IN_THE_PAST);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
    }

    @Test
    public void testMigrationNonTriggeredInterruptingTimerEvent() {
        Date futureDueDate = DateUtils.addYears((Date)ClockUtil.getCurrentTime(), (int)1);
        BpmnModelInstance model = this.createModel(true, sdf.format(futureDueDate));
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
    }

    @Test
    public void testMigrationTwoNonInterruptingTimerEvents() {
        Date futureDueDate = DateUtils.addYears((Date)ClockUtil.getCurrentTime(), (int)1);
        BpmnModelInstance model = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timerPast").cancelActivity(Boolean.valueOf(false))).timerWithDate(DUE_DATE_IN_THE_PAST)).userTask("past").moveToActivity("userTask").boundaryEvent("timerFuture").cancelActivity(Boolean.valueOf(false))).timerWithDate(sdf.format(futureDueDate))).userTask("future").done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().duedateLowerThan(ClockUtil.getCurrentTime()).singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().duedateHigherThan(ClockUtil.getCurrentTime()).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("past").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("future").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
    }

    @Test
    public void testMigrationWithTargetNonInterruptingTimerEvent() {
        BpmnModelInstance sourceModel = ((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).userTask("afterTimer").endEvent("endEvent").done();
        BpmnModelInstance targetModel = this.createModel(false, DUE_DATE_IN_THE_PAST);
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testMigrationWithSourceNonInterruptingTimerEvent() {
        BpmnModelInstance sourceModel = this.createModel(false, DUE_DATE_IN_THE_PAST);
        BpmnModelInstance targetModel = ((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).userTask("afterTimer").endEvent("endEvent").done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
    }

    @Test
    public void testMigrationTwoToOneNonInterruptingTimerEvents() {
        Date futureDueDate = DateUtils.addYears((Date)ClockUtil.getCurrentTime(), (int)1);
        BpmnModelInstance sourceModel = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timerPast").cancelActivity(Boolean.valueOf(false))).timerWithDate(DUE_DATE_IN_THE_PAST)).userTask("past").moveToActivity("userTask").boundaryEvent("timerFuture").cancelActivity(Boolean.valueOf(false))).timerWithDate(sdf.format(futureDueDate))).userTask("future").done();
        BpmnModelInstance targetModel = ((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timerFuture").cancelActivity(Boolean.valueOf(false))).timerWithDate(sdf.format(futureDueDate))).userTask("future").done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().activityId("timerPast").singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().mapActivities("timerPast", "timerFuture").mapActivities("past", "future").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().duedateHigherThan(ClockUtil.getCurrentTime()).list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("future").count());
    }

    @Test
    public void testMigrationOneToTwoNonInterruptingTimerEvents() {
        Date futureDueDate = DateUtils.addYears((Date)ClockUtil.getCurrentTime(), (int)1);
        BpmnModelInstance sourceModel = ((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timerFuture").cancelActivity(Boolean.valueOf(false))).timerWithDate(sdf.format(futureDueDate))).userTask("future").done();
        BpmnModelInstance targetModel = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timerPast").cancelActivity(Boolean.valueOf(false))).timerWithDate(DUE_DATE_IN_THE_PAST)).userTask("past").moveToActivity("userTask").boundaryEvent("timerFuture").cancelActivity(Boolean.valueOf(false))).timerWithDate(sdf.format(futureDueDate))).userTask("future").done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Assert.assertNull((Object)this.managementService.createJobQuery().activityId("timerPast").singleResult());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertBoundaryTimerJobMigrated("timerFuture", "timerFuture");
        this.testHelper.assertBoundaryTimerJobCreated("timerPast");
    }

    @Test
    public void testMigrationNonInterruptingTimerEventDifferentActivityId() {
        BpmnModelInstance sourceModel = this.createModel(false, DUE_DATE_IN_THE_PAST);
        BpmnModelInstance targetModel = ((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timer2").cancelActivity(Boolean.valueOf(false))).timerWithDate(DUE_DATE_IN_THE_PAST)).userTask("afterTimer").endEvent("endEvent").done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().mapActivities("timer", "timer2").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        List list = this.managementService.createJobQuery().list();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterTimer").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("userTask").count());
    }

    protected BpmnModelInstance createModel(boolean isCancelActivity, String date) {
        BpmnModelInstance model = ((BoundaryEventBuilder)((BoundaryEventBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").userTask("userTask").name("User Task")).boundaryEvent("timer").cancelActivity(Boolean.valueOf(isCancelActivity))).timerWithDate(date)).userTask("afterTimer").endEvent("endEvent").done();
        return model;
    }
}

