/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.TransactionModels;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.ExecutionAssert;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationTransactionTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testRule = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);

    @Test
    public void testContinueProcess() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("transaction", "transaction").mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.completeTask("userTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testContinueProcessTriggerCancellation() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.CANCEL_BOUNDARY_EVENT);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("transaction", "transaction").mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.completeTask("userTask");
        this.testRule.completeTask("afterBoundaryTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testAssertTrees() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("transaction", "transaction").mapActivities("userTask", "userTask").build();
        this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testRule.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testRule.getSingleExecutionIdForActivityBeforeMigration("userTask")).up().done());
        this.testRule.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("transaction", this.testRule.getSingleActivityInstanceBeforeMigration("transaction").getId()).activity("userTask", this.testRule.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
    }

    @Test
    public void testAddTransactionContinueProcess() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.completeTask("userTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testAddTransactionTriggerCancellation() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.CANCEL_BOUNDARY_EVENT);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.completeTask("userTask");
        this.testRule.completeTask("afterBoundaryTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testAddTransactionAssertTrees() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testRule.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().done());
        this.testRule.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("transaction").activity("userTask", this.testRule.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
    }

    @Test
    public void testRemoveTransactionContinueProcess() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.completeTask("userTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testRemoveTransactionAssertTrees() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        this.testRule.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testRule.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testRule.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testRule.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
    }

    @Test
    public void testMigrateTransactionToEmbeddedSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("transaction", "subProcess").mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.testRule.createProcessInstanceAndMigrate(migrationPlan);
        Assert.assertEquals((Object)this.testRule.getSingleActivityInstanceBeforeMigration("transaction").getId(), (Object)this.testRule.getSingleActivityInstanceAfterMigration("subProcess").getId());
        this.testRule.completeTask("userTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateEventSubProcessToTransaction() {
        ProcessDefinition sourceProcessDefinition = this.testRule.deployAndGetDefinition(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testRule.deployAndGetDefinition(TransactionModels.ONE_TASK_TRANSACTION);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("eventSubProcess", "transaction").mapActivities("eventSubProcessTask", "userTask").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("eventSubProcessTask")).execute();
        this.testRule.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((Object)this.testRule.getSingleActivityInstanceBeforeMigration("eventSubProcess").getId(), (Object)this.testRule.getSingleActivityInstanceAfterMigration("transaction").getId());
        this.testRule.completeTask("userTask");
        this.testRule.assertProcessEnded(processInstance.getId());
    }
}

