/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.SetProcessDefinitionVersionCmd;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.runtime.Incident;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class SetProcessDefinitionVersionCmdTest
extends PluggableProcessEngineTest {
    private static final String TEST_PROCESS_WITH_PARALLEL_GATEWAY = "org/eximeebpms/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml";
    private static final String TEST_PROCESS = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml";
    private static final String TEST_PROCESS_ACTIVITY_MISSING = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionActivityMissing.bpmn20.xml";
    private static final String TEST_PROCESS_CALL_ACTIVITY = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.withCallActivity.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V1 = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V2 = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTaskV2.bpmn20.xml";
    private static final String TEST_PROCESS_SERVICE_TASK_V1 = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTask.bpmn20.xml";
    private static final String TEST_PROCESS_SERVICE_TASK_V2 = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTaskV2.bpmn20.xml";
    private static final String TEST_PROCESS_WITH_MULTIPLE_PARENTS = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithMultipleParents.bpmn";
    private static final String TEST_PROCESS_ONE_JOB = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml";
    private static final String TEST_PROCESS_TWO_JOBS = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.twoJobsProcess.bpmn20.xml";
    private static final String TEST_PROCESS_ATTACHED_TIMER = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testAttachedTimer.bpmn20.xml";

    @Test
    public void testSetProcessDefinitionVersionEmptyArguments() {
        try {
            new SetProcessDefinitionVersionCmd(null, Integer.valueOf(23));
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process instance id is mandatory: processInstanceId is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("", Integer.valueOf(23));
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process instance id is mandatory: processInstanceId is empty", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition version is mandatory: processDefinitionVersion is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", Integer.valueOf(-1));
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The process definition version must be positive: processDefinitionVersion is not greater than 0", ae.getMessage());
        }
    }

    @Test
    public void testSetProcessDefinitionVersionNonExistingPI() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd("42", Integer.valueOf(23)));
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No process instance found for id = '42'.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionPIIsSubExecution() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("receivePayment").singleResult();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd command = new SetProcessDefinitionVersionCmd(execution.getId(), Integer.valueOf(1));
        try {
            commandExecutor.execute((Command)command);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("A process instance id is required, but the provided id '" + execution.getId() + "' points to a child execution of process instance '" + pi.getId() + "'. Please invoke the " + command.getClass().getSimpleName() + " with a root execution id.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionNonExistingPD() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(23)));
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no processes deployed with key = 'receiveTask', version = '23'", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionActivityMissing() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").singleResult();
        Assert.assertNotNull((Object)execution);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ACTIVITY_MISSING).deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd setProcessDefinitionVersionCmd = new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2));
        try {
            commandExecutor.execute((Command)setProcessDefinitionVersionCmd);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("The new process definition (key = 'receiveTask') does not contain the current activity (id = 'waitState1') of the process instance (id = '", ae.getMessage());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment
    @Test
    public void testSetProcessDefinitionVersion() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState1").singleResult();
        Assert.assertNotNull((Object)execution);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS).deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)newProcessDefinition.getId(), (Object)pi.getProcessDefinitionId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionSubExecutions() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_WITH_PARALLEL_GATEWAY).deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        for (Execution execution : executions) {
            Assert.assertEquals((Object)newProcessDefinition.getId(), (Object)((ExecutionEntity)execution).getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.withCallActivity.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("parentProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").processDefinitionKey("childProcess").singleResult();
        Assert.assertNotNull((Object)execution);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_CALL_ACTIVITY).deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("parentProcess").count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionWithWithTask() {
        try {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("userTask");
            Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(pi.getId()).count());
            org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_USER_TASK_V2).deploy();
            Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").count());
            ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").processDefinitionVersion(Integer.valueOf(2)).singleResult();
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            Assert.assertEquals((Object)newProcessDefinition.getId(), (Object)task.getProcessDefinitionId());
            Assert.assertEquals((Object)"testFormKey", (Object)this.formService.getTaskFormData(task.getId()).getFormKey());
            this.taskService.complete(task.getId());
            this.testRule.assertProcessEnded(pi.getId());
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTask.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionWithFollowUpTask() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_SERVICE_TASK_V2).deploy().getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Job migrationJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)migrationJob);
        this.managementService.executeJob(migrationJob.getId());
        Task followUpTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((String)"Should have migrated to the new version and immediately executed the correct follow-up activity", (Object)followUpTask);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithMultipleParents.bpmn"})
    @Test
    public void testSetProcessDefinitionVersionWithMultipleParents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleJoins");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task4").singleResult();
        Assert.assertNotNull((Object)task);
        Job job = (Job)this.managementService.createJobQuery().executionId(task.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_WITH_MULTIPLE_PARENTS).deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        for (Execution execution : executions) {
            Assert.assertEquals((Object)newProcessDefinition.getId(), (Object)((ExecutionEntity)execution).getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionMigrateJob() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Job migratedJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)migratedJob);
        Assert.assertEquals((Object)job.getId(), (Object)migratedJob.getId());
        Assert.assertEquals((Object)newDefinition.getId(), (Object)migratedJob.getProcessDefinitionId());
        Assert.assertEquals((Object)deployment.getId(), (Object)migratedJob.getDeploymentId());
        JobDefinition newJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionId(newDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)newJobDefinition);
        Assert.assertEquals((Object)newJobDefinition.getId(), (Object)migratedJob.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.twoJobsProcess.bpmn20.xml"})
    @Test
    public void testMigrateJobWithMultipleDefinitionsOnActivity() {
        ProcessInstance asyncAfterInstance = this.runtimeService.startProcessInstanceByKey("twoJobsProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Job asyncAfterJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstance asyncBeforeInstance = this.runtimeService.startProcessInstanceByKey("twoJobsProcess");
        Job asyncBeforeJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncBeforeInstance.getId()).singleResult();
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_TWO_JOBS).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)newDefinition);
        JobDefinition asnycBeforeJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-before").processDefinitionId(newDefinition.getId()).singleResult();
        JobDefinition asnycAfterJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-after").processDefinitionId(newDefinition.getId()).singleResult();
        Assert.assertNotNull((Object)asnycBeforeJobDefinition);
        Assert.assertNotNull((Object)asnycAfterJobDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(asyncBeforeInstance.getId(), Integer.valueOf(2)));
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(asyncAfterInstance.getId(), Integer.valueOf(2)));
        Job migratedAsyncBeforeJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncBeforeInstance.getId()).singleResult();
        Assert.assertEquals((Object)asyncBeforeJob.getId(), (Object)migratedAsyncBeforeJob.getId());
        Assert.assertNotNull((Object)migratedAsyncBeforeJob);
        Assert.assertEquals((Object)asnycBeforeJobDefinition.getId(), (Object)migratedAsyncBeforeJob.getJobDefinitionId());
        Job migratedAsyncAfterJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncAfterInstance.getId()).singleResult();
        Assert.assertEquals((Object)asyncAfterJob.getId(), (Object)migratedAsyncAfterJob.getId());
        Assert.assertNotNull((Object)migratedAsyncAfterJob);
        Assert.assertEquals((Object)asnycAfterJobDefinition.getId(), (Object)migratedAsyncAfterJob.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionMigrateIncident() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess", (Map)Variables.createVariables().putValue("shouldFail", (Object)true));
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Incident migratedIncident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)migratedIncident);
        Assert.assertEquals((Object)newDefinition.getId(), (Object)migratedIncident.getProcessDefinitionId());
        Assert.assertEquals((Object)instance.getId(), (Object)migratedIncident.getProcessInstanceId());
        Assert.assertEquals((Object)instance.getId(), (Object)migratedIncident.getExecutionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    @Test
    public void testPreserveTimestampOnUpdatedIncident() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess", (Map)Variables.createVariables().putValue("shouldFail", (Object)true));
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Date timestamp = incident.getIncidentTimestamp();
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Incident migratedIncident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertEquals((Object)timestamp, (Object)migratedIncident.getIncidentTimestamp());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testAttachedTimer.bpmn20.xml"})
    @Test
    public void testSetProcessDefinitionVersionAttachedTimer() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("attachedTimer");
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ATTACHED_TIMER).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)newDefinition.getId(), (Object)job.getProcessDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testHistoryOfSetProcessDefinitionVersionCmd() {
        String resource = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.bpmn";
        org.eximeebpms.bpm.engine.repository.Deployment firstDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        org.eximeebpms.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(firstDeployment.getId()).singleResult();
        ProcessDefinition processDefinitionV2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeployment.getId()).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionV1.getId());
        this.setProcessDefinitionVersion(processInstance.getId(), 2);
        ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)processDefinitionV2.getId(), (Object)processInstanceAfterMigration.getProcessDefinitionId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            Assert.assertEquals((Object)processDefinitionV2.getId(), (Object)historicProcessInstance.getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(firstDeployment.getId(), true);
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpLogSetProcessDefinitionVersionCmd() {
        try {
            this.identityService.setAuthenticatedUserId("demo");
            String resource = "org/eximeebpms/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.bpmn";
            org.eximeebpms.bpm.engine.repository.Deployment firstDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            org.eximeebpms.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(firstDeployment.getId()).singleResult();
            ProcessDefinition processDefinitionV2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeployment.getId()).singleResult();
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionV1.getId());
            this.setProcessDefinitionVersion(processInstance.getId(), 2);
            ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            Assert.assertEquals((Object)processDefinitionV2.getId(), (Object)processInstanceAfterMigration.getProcessDefinitionId());
            if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                List userOperations = this.historyService.createUserOperationLogQuery().processInstanceId(processInstance.getId()).operationType("ModifyProcessInstance").list();
                Assert.assertEquals((long)1L, (long)userOperations.size());
                UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)userOperations.get(0);
                Assert.assertEquals((Object)"processDefinitionVersion", (Object)userOperationLogEntry.getProperty());
                Assert.assertEquals((Object)"1", (Object)userOperationLogEntry.getOrgValue());
                Assert.assertEquals((Object)"2", (Object)userOperationLogEntry.getNewValue());
            }
            this.repositoryService.deleteDeployment(firstDeployment.getId(), true);
            this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    protected void setProcessDefinitionVersion(String processInstanceId, int newProcessDefinitionVersion) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequiresNew();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(processInstanceId, Integer.valueOf(newProcessDefinitionVersion)));
    }
}

