/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.history;

import java.util.Arrays;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.AsyncProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MigrationHistoricIncidentTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.historyService = this.rule.getHistoryService();
        this.runtimeService = this.rule.getRuntimeService();
        this.managementService = this.rule.getManagementService();
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testMigrateHistoricIncident() {
        ProcessDefinition sourceProcess = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcess = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS).changeElementId("Process", "newProcess").changeElementId("userTask", "newUserTask"));
        JobDefinition targetJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionId(targetProcess.getId()).singleResult();
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcess.getId(), targetProcess.getId()).mapActivities("userTask", "newUserTask").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcess.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        HistoricIncident incidentBeforeMigration = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertEquals((Object)"newUserTask", (Object)historicIncident.getActivityId());
        Assert.assertEquals((Object)targetJobDefinition.getId(), (Object)historicIncident.getJobDefinitionId());
        Assert.assertEquals((Object)targetProcess.getId(), (Object)historicIncident.getProcessDefinitionId());
        Assert.assertEquals((Object)targetProcess.getKey(), (Object)historicIncident.getProcessDefinitionKey());
        Assert.assertEquals((Object)processInstance.getId(), (Object)historicIncident.getExecutionId());
        Assert.assertEquals((Object)incidentBeforeMigration.getCreateTime(), (Object)historicIncident.getCreateTime());
        Assert.assertEquals((Object)incidentBeforeMigration.getProcessInstanceId(), (Object)historicIncident.getProcessInstanceId());
    }

    @Test
    public void testMigrateHistoricIncidentAddScope() {
        ProcessDefinition sourceProcess = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcess = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcess.getId(), targetProcess.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcess.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 0);
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assert.assertNotNull((Object)historicIncident);
        Assert.assertEquals((Object)activityInstance.getTransitionInstances("userTask")[0].getExecutionId(), (Object)historicIncident.getExecutionId());
    }
}

