/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.history;

import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHistoricProcessInstanceTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ProcessDefinition sourceProcessDefinition;
    protected ProcessDefinition targetProcessDefinition;
    protected MigrationPlan migrationPlan;

    @Before
    public void initTest() {
        this.runtimeService = this.rule.getRuntimeService();
        this.historyService = this.rule.getHistoryService();
        this.sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ModifiableBpmnModelInstance modifiedModel = ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "Process2").changeElementId("userTask", "userTask2");
        this.targetProcessDefinition = this.testHelper.deployAndGetDefinition(modifiedModel);
        this.migrationPlan = this.runtimeService.createMigrationPlan(this.sourceProcessDefinition.getId(), this.targetProcessDefinition.getId()).mapActivities("userTask", "userTask2").build();
        this.runtimeService.startProcessInstanceById(this.sourceProcessDefinition.getId());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoryProcessInstance() {
        HistoricProcessInstanceQuery sourceHistoryProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId());
        HistoricProcessInstanceQuery targetHistoryProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(this.targetProcessDefinition.getId());
        Assert.assertEquals((long)1L, (long)sourceHistoryProcessInstanceQuery.count());
        Assert.assertEquals((long)0L, (long)targetHistoryProcessInstanceQuery.count());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId());
        this.runtimeService.newMigration(this.migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)0L, (long)sourceHistoryProcessInstanceQuery.count());
        Assert.assertEquals((long)1L, (long)targetHistoryProcessInstanceQuery.count());
        HistoricProcessInstance instance = (HistoricProcessInstance)targetHistoryProcessInstanceQuery.singleResult();
        Assert.assertEquals((Object)instance.getProcessDefinitionKey(), (Object)this.targetProcessDefinition.getKey());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoryProcessInstanceState() {
        HistoricProcessInstanceQuery sourceHistoryProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId());
        HistoricProcessInstanceQuery targetHistoryProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processDefinitionId(this.targetProcessDefinition.getId());
        HistoricProcessInstance historicProcessInstanceBeforeMigration = (HistoricProcessInstance)sourceHistoryProcessInstanceQuery.singleResult();
        Assert.assertEquals((Object)"ACTIVE", (Object)historicProcessInstanceBeforeMigration.getState());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(this.sourceProcessDefinition.getId());
        this.runtimeService.newMigration(this.migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).execute();
        HistoricProcessInstance instance = (HistoricProcessInstance)targetHistoryProcessInstanceQuery.singleResult();
        Assert.assertEquals((Object)historicProcessInstanceBeforeMigration.getState(), (Object)instance.getState());
    }
}

