/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.history;

import java.util.Arrays;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationHistoricTaskInstanceTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.historyService = this.rule.getHistoryService();
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateHistoryUserTaskInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "Process2").changeElementId("userTask", "userTask2"));
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        HistoricTaskInstanceQuery sourceHistoryTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        HistoricTaskInstanceQuery targetHistoryTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(targetProcessDefinition.getId());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((long)1L, (long)sourceHistoryTaskInstanceQuery.count());
        Assert.assertEquals((long)0L, (long)targetHistoryTaskInstanceQuery.count());
        ProcessInstanceQuery sourceProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        this.runtimeService.newMigration(migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).execute();
        Assert.assertEquals((long)0L, (long)sourceHistoryTaskInstanceQuery.count());
        Assert.assertEquals((long)1L, (long)targetHistoryTaskInstanceQuery.count());
        HistoricTaskInstance instance = (HistoricTaskInstance)targetHistoryTaskInstanceQuery.singleResult();
        Assert.assertEquals((Object)targetProcessDefinition.getKey(), (Object)instance.getProcessDefinitionKey());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)instance.getProcessDefinitionId());
        Assert.assertEquals((Object)"userTask2", (Object)instance.getTaskDefinitionKey());
        Assert.assertEquals((Object)activityInstance.getActivityInstances("userTask")[0].getId(), (Object)instance.getActivityInstanceId());
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void testMigrateWithSubTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Task subTask = this.taskService.newTask();
        subTask.setParentTaskId(task.getId());
        this.taskService.saveTask(subTask);
        this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        HistoricTaskInstance historicSubTaskAfterMigration = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(subTask.getId()).singleResult();
        Assert.assertNotNull((Object)historicSubTaskAfterMigration);
        Assert.assertNull((Object)historicSubTaskAfterMigration.getProcessDefinitionId());
        Assert.assertNull((Object)historicSubTaskAfterMigration.getProcessDefinitionKey());
        Assert.assertNull((Object)historicSubTaskAfterMigration.getExecutionId());
        Assert.assertNull((Object)historicSubTaskAfterMigration.getActivityInstanceId());
    }
}

