/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.util;

import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;

public class MessageEventFactory
implements BpmnEventFactory {
    public static final String MESSAGE_NAME = "message";

    @Override
    public MigratingBpmnEventTrigger addBoundaryEvent(ProcessEngine engine, BpmnModelInstance modelInstance, String activityId, String boundaryEventId) {
        ((BoundaryEventBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).activityBuilder(activityId).boundaryEvent(boundaryEventId).message(MESSAGE_NAME)).done();
        MessageTrigger trigger = new MessageTrigger();
        trigger.engine = engine;
        trigger.messageName = MESSAGE_NAME;
        trigger.activityId = boundaryEventId;
        return trigger;
    }

    @Override
    public MigratingBpmnEventTrigger addEventSubProcess(ProcessEngine engine, BpmnModelInstance modelInstance, String parentId, String subProcessId, String startEventId) {
        ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).addSubProcessTo(parentId).id(subProcessId)).triggerByEvent()).embeddedSubProcess().startEvent(startEventId).message(MESSAGE_NAME)).subProcessDone().done();
        MessageTrigger trigger = new MessageTrigger();
        trigger.engine = engine;
        trigger.messageName = MESSAGE_NAME;
        trigger.activityId = startEventId;
        return trigger;
    }

    protected static class MessageTrigger
    implements MigratingBpmnEventTrigger {
        protected ProcessEngine engine;
        protected String activityId;
        protected String messageName;

        protected MessageTrigger() {
        }

        @Override
        public void trigger(String processInstanceId) {
            this.engine.getRuntimeService().createMessageCorrelation(this.messageName).processInstanceId(processInstanceId).correlateWithResult();
        }

        @Override
        public void assertEventTriggerMigrated(MigrationTestRule migrationContext, String targetActivityId) {
            migrationContext.assertEventSubscriptionMigrated(this.activityId, targetActivityId, this.messageName);
        }

        @Override
        public MigratingBpmnEventTrigger inContextOf(String newActivityId) {
            MessageTrigger newTrigger = new MessageTrigger();
            newTrigger.activityId = newActivityId;
            newTrigger.engine = this.engine;
            newTrigger.messageName = this.messageName;
            return newTrigger;
        }
    }
}

