/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration.util;

import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.BpmnEventFactory;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.util.MigratingBpmnEventTrigger;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;

public class SignalEventFactory
implements BpmnEventFactory {
    public static final String SIGNAL_NAME = "signal";

    @Override
    public MigratingBpmnEventTrigger addBoundaryEvent(ProcessEngine engine, BpmnModelInstance modelInstance, String activityId, String boundaryEventId) {
        ((BoundaryEventBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).activityBuilder(activityId).boundaryEvent(boundaryEventId).signal(SIGNAL_NAME)).done();
        SignalTrigger trigger = new SignalTrigger();
        trigger.engine = engine;
        trigger.signalName = SIGNAL_NAME;
        trigger.activityId = boundaryEventId;
        return trigger;
    }

    @Override
    public MigratingBpmnEventTrigger addEventSubProcess(ProcessEngine engine, BpmnModelInstance modelInstance, String parentId, String subProcessId, String startEventId) {
        ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.wrap(modelInstance).addSubProcessTo(parentId).id(subProcessId)).triggerByEvent()).embeddedSubProcess().startEvent(startEventId).signal(SIGNAL_NAME)).subProcessDone().done();
        SignalTrigger trigger = new SignalTrigger();
        trigger.engine = engine;
        trigger.signalName = SIGNAL_NAME;
        trigger.activityId = startEventId;
        return trigger;
    }

    protected static class SignalTrigger
    implements MigratingBpmnEventTrigger {
        protected ProcessEngine engine;
        protected String signalName;
        protected String activityId;

        protected SignalTrigger() {
        }

        @Override
        public void trigger(String processInstanceId) {
            EventSubscription eventSubscription = (EventSubscription)this.engine.getRuntimeService().createEventSubscriptionQuery().activityId(this.activityId).eventName(this.signalName).processInstanceId(processInstanceId).singleResult();
            if (eventSubscription == null) {
                throw new RuntimeException("Event subscription not found");
            }
            this.engine.getRuntimeService().signalEventReceived(eventSubscription.getEventName(), eventSubscription.getExecutionId());
        }

        @Override
        public void assertEventTriggerMigrated(MigrationTestRule migrationContext, String targetActivityId) {
            migrationContext.assertEventSubscriptionMigrated(this.activityId, targetActivityId, SignalEventFactory.SIGNAL_NAME);
        }

        @Override
        public MigratingBpmnEventTrigger inContextOf(String newActivityId) {
            SignalTrigger newTrigger = new SignalTrigger();
            newTrigger.activityId = newActivityId;
            newTrigger.engine = this.engine;
            newTrigger.signalName = this.signalName;
            return newTrigger;
        }
    }
}

