/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.impl.TaskQueryImpl;
import org.eximeebpms.bpm.engine.impl.calendar.DateTimeUtil;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.mock.Mocks;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskQueryExpressionTest {
    protected Task task;
    protected User user;
    protected User anotherUser;
    protected User userWithoutGroups;
    protected Group group1;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/api/task/task-query-expression-test.eximeebpms.cfg.xml");
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.group1 = this.createGroup("group1");
        Group group2 = this.createGroup("group2");
        Group group3 = this.createGroup("group3");
        this.user = this.createUser("user", this.group1.getId(), group2.getId());
        this.anotherUser = this.createUser("anotherUser", group3.getId());
        this.userWithoutGroups = this.createUser("userWithoutGroups", new String[0]);
        this.setTime(1427547759000L);
        this.task = this.createTestTask("task");
        this.adjustTime(120);
        Task anotherTask = this.createTestTask("anotherTask");
        Task assignedCandidateTask = this.createTestTask("assignedCandidateTask");
        this.taskService.setOwner(this.task.getId(), this.user.getId());
        this.taskService.setAssignee(this.task.getId(), this.user.getId());
        this.taskService.addCandidateUser(anotherTask.getId(), this.user.getId());
        this.taskService.addCandidateGroup(anotherTask.getId(), this.group1.getId());
        this.taskService.setAssignee(assignedCandidateTask.getId(), this.user.getId());
        this.taskService.addCandidateUser(assignedCandidateTask.getId(), this.user.getId());
        this.taskService.addCandidateGroup(assignedCandidateTask.getId(), this.group1.getId());
    }

    @Test
    public void testQueryByAssigneeExpression() {
        this.assertCount((Query)this.taskQuery().taskAssigneeExpression("${'" + this.user.getId() + "'}"), 2L);
        this.assertCount((Query)this.taskQuery().taskAssigneeExpression("${'" + this.anotherUser.getId() + "'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskAssigneeExpression("${currentUser()}"), 2L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskAssigneeExpression("${currentUser()}"), 0L);
    }

    @Test
    public void testQueryByAssigneeLikeExpression() {
        this.assertCount((Query)this.taskQuery().taskAssigneeLikeExpression("${'%" + this.user.getId().substring(2) + "'}"), 2L);
        this.assertCount((Query)this.taskQuery().taskAssigneeLikeExpression("${'%" + this.anotherUser.getId().substring(2) + "'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskAssigneeLikeExpression("${'%'.concat(currentUser())}"), 2L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskAssigneeLikeExpression("${'%'.concat(currentUser())}"), 0L);
    }

    @Test
    public void testQueryByOwnerExpression() {
        this.assertCount((Query)this.taskQuery().taskOwnerExpression("${'" + this.user.getId() + "'}"), 1L);
        this.assertCount((Query)this.taskQuery().taskOwnerExpression("${'" + this.anotherUser.getId() + "'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskOwnerExpression("${currentUser()}"), 1L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskOwnerExpression("${currentUser()}"), 0L);
    }

    @Test
    public void testQueryByInvolvedUserExpression() {
        this.assertCount((Query)this.taskQuery().taskInvolvedUserExpression("${'" + this.user.getId() + "'}"), 3L);
        this.assertCount((Query)this.taskQuery().taskInvolvedUserExpression("${'" + this.anotherUser.getId() + "'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskInvolvedUserExpression("${currentUser()}"), 3L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskInvolvedUserExpression("${currentUser()}"), 0L);
    }

    @Test
    public void testQueryByCandidateUserExpression() {
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${'" + this.user.getId() + "'}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${'" + this.user.getId() + "'}").includeAssignedTasks(), 2L);
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${'" + this.anotherUser.getId() + "'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${currentUser()}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${currentUser()}").includeAssignedTasks(), 2L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskCandidateUserExpression("${currentUser()}"), 0L);
    }

    @Test
    public void testQueryByCandidateGroupExpression() {
        this.assertCount((Query)this.taskQuery().taskCandidateGroupExpression("${'" + this.group1.getId() + "'}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupExpression("${'unknown'}"), 0L);
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupExpression("${currentUserGroups()[0]}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupExpression("${currentUserGroups()[0]}").includeAssignedTasks(), 2L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupExpression("${currentUserGroups()[0]}"), 0L);
    }

    @Test
    public void testQueryByCandidateGroupsExpression() {
        this.setCurrentUser(this.user);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupInExpression("${currentUserGroups()}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupInExpression("${currentUserGroups()}").includeAssignedTasks(), 2L);
        this.setCurrentUser(this.anotherUser);
        this.assertCount((Query)this.taskQuery().taskCandidateGroupInExpression("${currentUserGroups()}"), 0L);
        this.setCurrentUser(this.userWithoutGroups);
        try {
            this.taskQuery().taskCandidateGroupInExpression("${currentUserGroups()}").count();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByTaskCreatedBeforeExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().taskCreatedBeforeExpression("${now()}"), 3L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().taskCreatedBeforeExpression("${now()}"), 0L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().taskCreatedBeforeExpression("${dateTime().plusMonths(2)}"), 3L);
        this.assertCount((Query)this.taskQuery().taskCreatedBeforeExpression("${dateTime().minusYears(1)}"), 0L);
    }

    @Test
    public void testQueryByTaskCreatedOnExpression() {
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().taskCreatedOnExpression("${now()}"), 1L);
        this.adjustTime(10);
        this.assertCount((Query)this.taskQuery().taskCreatedOnExpression("${dateTime().minusSeconds(10)}"), 1L);
        this.assertCount((Query)this.taskQuery().taskCreatedOnExpression("${now()}"), 0L);
    }

    @Test
    public void testQueryByTaskCreatedAfterExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().taskCreatedAfterExpression("${now()}"), 0L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().taskCreatedAfterExpression("${now()}"), 3L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().taskCreatedAfterExpression("${dateTime().plusMonths(2)}"), 0L);
        this.assertCount((Query)this.taskQuery().taskCreatedAfterExpression("${dateTime().minusYears(1)}"), 3L);
    }

    @Test
    public void testQueryByTaskUpdatedAfterExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().taskUpdatedAfterExpression("${now()}"), 0L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().taskUpdatedAfterExpression("${now()}"), 3L);
        this.setTime(this.task.getLastUpdated());
        this.assertCount((Query)this.taskQuery().taskUpdatedAfterExpression("${dateTime().plusMonths(2)}"), 0L);
        this.assertCount((Query)this.taskQuery().taskUpdatedAfterExpression("${dateTime().minusYears(1)}"), 3L);
    }

    @Test
    public void testQueryByDueBeforeExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().dueBeforeExpression("${now()}"), 3L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().dueBeforeExpression("${now()}"), 0L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().dueBeforeExpression("${dateTime().plusMonths(2)}"), 3L);
        this.assertCount((Query)this.taskQuery().dueBeforeExpression("${dateTime().minusYears(1)}"), 0L);
    }

    @Test
    public void testQueryByDueDateExpression() {
        this.setTime(this.task.getDueDate());
        this.assertCount((Query)this.taskQuery().dueDateExpression("${now()}"), 1L);
        this.adjustTime(10);
        this.assertCount((Query)this.taskQuery().dueDateExpression("${dateTime().minusSeconds(10)}"), 1L);
        this.assertCount((Query)this.taskQuery().dueDateExpression("${now()}"), 0L);
    }

    @Test
    public void testQueryByDueAfterExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().dueAfterExpression("${now()}"), 0L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().dueAfterExpression("${now()}"), 3L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().dueAfterExpression("${dateTime().plusMonths(2)}"), 0L);
        this.assertCount((Query)this.taskQuery().dueAfterExpression("${dateTime().minusYears(1)}"), 3L);
    }

    @Test
    public void testQueryByFollowUpBeforeExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().followUpBeforeExpression("${now()}"), 3L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().followUpBeforeExpression("${now()}"), 0L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().followUpBeforeExpression("${dateTime().plusMonths(2)}"), 3L);
        this.assertCount((Query)this.taskQuery().followUpBeforeExpression("${dateTime().minusYears(1)}"), 0L);
    }

    @Test
    public void testQueryByFollowUpDateExpression() {
        this.setTime(this.task.getFollowUpDate());
        this.assertCount((Query)this.taskQuery().followUpDateExpression("${now()}"), 1L);
        this.adjustTime(10);
        this.assertCount((Query)this.taskQuery().followUpDateExpression("${dateTime().minusSeconds(10)}"), 1L);
        this.assertCount((Query)this.taskQuery().followUpDateExpression("${now()}"), 0L);
    }

    @Test
    public void testQueryByFollowUpAfterExpression() {
        this.adjustTime(1);
        this.assertCount((Query)this.taskQuery().followUpAfterExpression("${now()}"), 0L);
        this.adjustTime(-300);
        this.assertCount((Query)this.taskQuery().followUpAfterExpression("${now()}"), 3L);
        this.setTime(this.task.getCreateTime());
        this.assertCount((Query)this.taskQuery().followUpAfterExpression("${dateTime().plusMonths(2)}"), 0L);
        this.assertCount((Query)this.taskQuery().followUpAfterExpression("${dateTime().minusYears(1)}"), 3L);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKey", (Object)aBusinessKey);
        this.createBusinessKeyDeployment(aBusinessKey);
        TaskQuery taskQuery = this.taskQuery().processInstanceBusinessKeyExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        this.assertCount((Query)taskQuery, 1L);
    }

    @Test
    public void testQueryByProcessInstanceBusinessKeyLikeExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKeyLike", (Object)("%" + aBusinessKey.substring(5)));
        this.createBusinessKeyDeployment(aBusinessKey);
        TaskQuery taskQuery = this.taskQuery().processInstanceBusinessKeyLikeExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        this.assertCount((Query)taskQuery, 1L);
    }

    protected void createBusinessKeyDeployment(String aBusinessKey) {
        BpmnModelInstance modelInstance = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"aProcessDefinition").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask().endEvent().done();
        this.testRule.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", aBusinessKey);
    }

    @Test
    public void testExpressionOverrideQuery() {
        String queryString = "query";
        String expressionString = "expression";
        String testStringExpression = "${'" + expressionString + "'}";
        Date queryDate = new DateTime((Object)this.now()).minusYears(1).toDate();
        String testDateExpression = "${now()}";
        TaskQueryImpl taskQuery = (TaskQueryImpl)this.taskQuery().taskAssignee(queryString).taskAssigneeExpression(testStringExpression).taskAssigneeLike(queryString).taskAssigneeLikeExpression(testStringExpression).taskOwnerExpression(queryString).taskOwnerExpression(expressionString).taskInvolvedUser(queryString).taskInvolvedUserExpression(expressionString).taskCreatedBefore(queryDate).taskCreatedBeforeExpression(testDateExpression).taskCreatedOn(queryDate).taskCreatedOnExpression(testDateExpression).taskCreatedAfter(queryDate).taskCreatedAfterExpression(testDateExpression).dueBefore(queryDate).dueBeforeExpression(testDateExpression).dueDate(queryDate).dueDateExpression(testDateExpression).dueAfter(queryDate).dueAfterExpression(testDateExpression).followUpBefore(queryDate).followUpBeforeExpression(testDateExpression).followUpDate(queryDate).followUpDateExpression(testDateExpression).followUpAfter(queryDate).followUpAfterExpression(testDateExpression);
        taskQuery.count();
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getAssignee());
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getAssigneeLike());
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getOwner());
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getInvolvedUser());
        Assert.assertTrue((boolean)taskQuery.getCreateTimeBefore().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getCreateTime().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getCreateTimeAfter().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getDueBefore().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getDueDate().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getDueAfter().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getFollowUpBefore().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getFollowUpDate().after(queryDate));
        Assert.assertTrue((boolean)taskQuery.getFollowUpAfter().after(queryDate));
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateGroup(queryString).taskCandidateGroupExpression(testStringExpression);
        taskQuery.count();
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getCandidateGroup());
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateUser(queryString).taskCandidateUserExpression(testStringExpression);
        taskQuery.count();
        Assert.assertEquals((Object)expressionString, (Object)taskQuery.getCandidateUser());
        this.setCurrentUser(this.user);
        List<String> queryList = Arrays.asList("query");
        String testGroupsExpression = "${currentUserGroups()}";
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateGroupIn(queryList).taskCandidateGroupInExpression(testGroupsExpression);
        taskQuery.count();
        Assert.assertEquals((long)2L, (long)taskQuery.getCandidateGroups().size());
    }

    @Test
    public void testQueryOverrideExpression() {
        String queryString = "query";
        String expressionString = "expression";
        String testStringExpression = "${'" + expressionString + "'}";
        Date queryDate = new DateTime((Object)this.now()).minusYears(1).toDate();
        String testDateExpression = "${now()}";
        TaskQueryImpl taskQuery = (TaskQueryImpl)this.taskQuery().taskAssigneeExpression(testStringExpression).taskAssignee(queryString).taskAssigneeLikeExpression(testStringExpression).taskAssigneeLike(queryString).taskOwnerExpression(expressionString).taskOwner(queryString).taskInvolvedUserExpression(expressionString).taskInvolvedUser(queryString).taskCreatedBeforeExpression(testDateExpression).taskCreatedBefore(queryDate).taskCreatedOnExpression(testDateExpression).taskCreatedOn(queryDate).taskCreatedAfterExpression(testDateExpression).taskCreatedAfter(queryDate).taskUpdatedAfterExpression(testDateExpression).taskUpdatedAfter(queryDate).dueBeforeExpression(testDateExpression).dueBefore(queryDate).dueDateExpression(testDateExpression).dueDate(queryDate).dueAfterExpression(testDateExpression).dueAfter(queryDate).followUpBeforeExpression(testDateExpression).followUpBefore(queryDate).followUpDateExpression(testDateExpression).followUpDate(queryDate).followUpAfterExpression(testDateExpression).followUpAfter(queryDate);
        taskQuery.count();
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getAssignee());
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getAssigneeLike());
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getOwner());
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getInvolvedUser());
        Assertions.assertThat((Date)taskQuery.getUpdatedAfter()).isEqualTo((Object)queryDate);
        Assertions.assertThat((boolean)taskQuery.getCreateTimeBefore().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getCreateTime().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getCreateTimeAfter().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getDueBefore().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getDueDate().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getDueAfter().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getFollowUpBefore().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getFollowUpDate().equals(queryDate));
        Assertions.assertThat((boolean)taskQuery.getFollowUpAfter().equals(queryDate));
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateGroupExpression(testStringExpression).taskCandidateGroup(queryString);
        taskQuery.count();
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getCandidateGroup());
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateUserExpression(testStringExpression).taskCandidateUser(queryString);
        taskQuery.count();
        Assertions.assertThat((String)queryString).isEqualTo((Object)taskQuery.getCandidateUser());
        this.setCurrentUser(this.user);
        List<String> queryList = Arrays.asList("query");
        String testGroupsExpression = "${currentUserGroups()}";
        taskQuery = (TaskQueryImpl)this.taskQuery().taskCandidateGroupInExpression(testGroupsExpression).taskCandidateGroupIn(queryList);
        taskQuery.count();
        Assertions.assertThat((int)taskQuery.getCandidateGroups().size()).isEqualTo(1);
    }

    @Test
    public void testQueryOr() {
        Date date = DateTimeUtil.now().plusDays(2).toDate();
        Task task1 = this.taskService.newTask();
        task1.setFollowUpDate(date);
        task1.setOwner("Luke Optim");
        task1.setName("taskForOr");
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setDueDate(date);
        task2.setName("taskForOr");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setAssignee("John Munda");
        task3.setDueDate(date);
        task3.setName("taskForOr");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("taskForOr");
        this.taskService.saveTask(task4);
        List tasks = this.taskService.createTaskQuery().taskName("taskForOr").or().followUpAfterExpression("${ now() }").taskAssigneeLikeExpression("${ 'John%' }").endOr().or().taskOwnerExpression("${ 'Luke Optim' }").dueAfterExpression("${ now() }").endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldRejectDueDateExpressionAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueDateExpression("").withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueDateExpressionCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueDateExpression("")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectDueAfterExpressionAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueAfterExpression("").withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueAfterExpressionCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueAfterExpression("")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectDueBeforeExpressionAndWithoutDueDateCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().dueBeforeExpression("").withoutDueDate()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @Test
    public void shouldRejectWithoutDueDateAndDueBeforeExpressionCombination() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.createTaskQuery().withoutDueDate().dueBeforeExpression("")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage");
    }

    @After
    public void tearDown() {
        Mocks.reset();
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            if (task.getProcessInstanceId() != null) continue;
            this.taskService.deleteTask(task.getId(), true);
        }
        this.identityService.clearAuthentication();
    }

    protected TaskQuery taskQuery() {
        return this.taskService.createTaskQuery();
    }

    protected void assertCount(Query query, long count) {
        Assert.assertEquals((long)count, (long)query.count());
    }

    protected void setCurrentUser(User user) {
        List groups = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        this.identityService.setAuthentication(user.getId(), groupIds);
    }

    protected Group createGroup(String groupId) {
        Group group = this.identityService.newGroup(groupId);
        this.identityService.saveGroup(group);
        return group;
    }

    protected User createUser(String userId, String ... groupIds) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        if (groupIds != null) {
            for (String groupId : groupIds) {
                this.identityService.createMembership(userId, groupId);
            }
        }
        return user;
    }

    protected Task createTestTask(String taskId) {
        Task task = this.taskService.newTask(taskId);
        task.setDueDate(task.getCreateTime());
        this.taskService.saveTask(task);
        task.setFollowUpDate(task.getCreateTime());
        this.taskService.saveTask(task);
        return task;
    }

    protected Date now() {
        return ClockUtil.getCurrentTime();
    }

    protected void setTime(long time) {
        this.setTime(new Date(time));
    }

    protected void setTime(Date time) {
        ClockUtil.setCurrentTime((Date)time);
    }

    protected void adjustTime(int amount) {
        long time = this.now().getTime() + (long)(amount * 1000);
        this.setTime(time);
    }
}

