/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.AbstractVariableQueryImpl;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractVariableIgnoreCaseTest<T extends AbstractVariableQueryImpl, U> {
    protected static final String VARIABLE_NAME = "variableName";
    protected static final String VARIABLE_NAME_LC = "variableName".toLowerCase();
    protected static final String VARIABLE_VALUE = "variableValue";
    protected static final String VARIABLE_VALUE_LC = "variableValue".toLowerCase();
    protected static final String VARIABLE_VALUE_LC_LIKE = "%" + VARIABLE_VALUE_LC.substring(2, 10) + "%";
    protected static final String VARIABLE_VALUE_NE = "nonExistent";
    protected static Map<String, Object> VARIABLES = new HashMap<String, Object>();
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public U instance;

    protected abstract T createQuery();

    protected abstract void assertThatTwoInstancesAreEqual(U var1, U var2);

    protected T queryNameIgnoreCase() {
        return (T)((AbstractVariableQueryImpl)this.createQuery().matchVariableNamesIgnoreCase());
    }

    protected T queryValueIgnoreCase() {
        return (T)((AbstractVariableQueryImpl)this.createQuery().matchVariableValuesIgnoreCase());
    }

    protected T queryNameValueIgnoreCase() {
        return (T)((AbstractVariableQueryImpl)this.queryNameIgnoreCase().matchVariableValuesIgnoreCase());
    }

    protected void assertThatListContainsOnlyExpectedElement(List<U> instances, U instance) {
        Assertions.assertThat((int)instances.size()).isEqualTo(1);
        this.assertThatTwoInstancesAreEqual(instances.get(0), instance);
    }

    @Test
    public void testVariableNameEqualsIgnoreCase() {
        List eq = this.queryNameIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryNameIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, this.instance);
        Assertions.assertThat((List)eqValueLC).isEmpty();
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testVariableNameNotEqualsIgnoreCase() {
        List neq = this.queryNameIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryNameIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueNE = this.queryNameIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameLCValueNE = this.queryNameIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, this.instance);
    }

    @Test
    public void testVariableValueEqualsIgnoreCase() {
        List eq = this.queryValueIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryValueIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryValueIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = this.queryValueIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        Assertions.assertThat((List)eqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, this.instance);
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testVariableValueNotEqualsIgnoreCase() {
        List neq = this.queryValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueNE = this.queryValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameLCValueNE = this.queryValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        Assertions.assertThat((List)neqNameLCValueNE).isEmpty();
    }

    @Test
    public void testVariableValueLikeIgnoreCase() {
        List like = this.queryNameValueIgnoreCase().variableValueLike(VARIABLE_NAME, VARIABLE_VALUE).list();
        List likeValueLC = this.queryValueIgnoreCase().variableValueLike(VARIABLE_NAME, VARIABLE_VALUE_LC_LIKE).list();
        this.assertThatListContainsOnlyExpectedElement(like, this.instance);
        this.assertThatListContainsOnlyExpectedElement(likeValueLC, this.instance);
    }

    @Test
    public void testVariableNameAndValueEqualsIgnoreCase() {
        List eq = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List eqNameLC = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List eqValueLC = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List eqValueNE = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List eqNameValueLC = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List eqNameLCValueNE = this.queryNameValueIgnoreCase().variableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        this.assertThatListContainsOnlyExpectedElement(eq, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqNameLC, this.instance);
        this.assertThatListContainsOnlyExpectedElement(eqValueLC, this.instance);
        Assertions.assertThat((List)eqValueNE).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(eqNameValueLC, this.instance);
        Assertions.assertThat((List)eqNameLCValueNE).isEmpty();
    }

    @Test
    public void testVariableNameAndValueNotEqualsIgnoreCase() {
        List neq = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE).list();
        List neqNameLC = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE).list();
        List neqValueLC = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_LC).list();
        List neqValueNE = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME, (Object)VARIABLE_VALUE_NE).list();
        List neqNameValueLC = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List neqNameLCValueNE = this.queryNameValueIgnoreCase().variableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_NE).list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        Assertions.assertThat((List)neqValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqValueNE, this.instance);
        Assertions.assertThat((List)neqNameValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElement(neqNameLCValueNE, this.instance);
    }

    static {
        VARIABLES.put(VARIABLE_NAME, VARIABLE_VALUE);
    }
}

